/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecoveryOptionNameType {
    VERIFIED_EMAIL("verified_email"),
    VERIFIED_PHONE_NUMBER("verified_phone_number"),
    ADMIN_ONLY("admin_only"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecoveryOptionNameType> VALUE_MAP;
    private final String value;

    private RecoveryOptionNameType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecoveryOptionNameType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecoveryOptionNameType> knownValues() {
        EnumSet<RecoveryOptionNameType> knownValues = EnumSet.allOf(RecoveryOptionNameType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecoveryOptionNameType.class, RecoveryOptionNameType::toString);
    }
}

