/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CompromisedCredentialsActionsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventFilterType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EventFiltersTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompromisedCredentialsRiskConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompromisedCredentialsRiskConfigurationType> {
    private static final SdkField<List<String>> EVENT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventFilter").getter(CompromisedCredentialsRiskConfigurationType.getter(CompromisedCredentialsRiskConfigurationType::eventFilterAsStrings)).setter(CompromisedCredentialsRiskConfigurationType.setter(Builder::eventFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CompromisedCredentialsActionsType> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Actions").getter(CompromisedCredentialsRiskConfigurationType.getter(CompromisedCredentialsRiskConfigurationType::actions)).setter(CompromisedCredentialsRiskConfigurationType.setter(Builder::actions)).constructor(CompromisedCredentialsActionsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FILTER_FIELD, ACTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> eventFilter;
    private final CompromisedCredentialsActionsType actions;

    private CompromisedCredentialsRiskConfigurationType(BuilderImpl builder) {
        this.eventFilter = builder.eventFilter;
        this.actions = builder.actions;
    }

    public final List<EventFilterType> eventFilter() {
        return EventFiltersTypeCopier.copyStringToEnum(this.eventFilter);
    }

    public final boolean hasEventFilter() {
        return this.eventFilter != null && !(this.eventFilter instanceof SdkAutoConstructList);
    }

    public final List<String> eventFilterAsStrings() {
        return this.eventFilter;
    }

    public final CompromisedCredentialsActionsType actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventFilter() ? this.eventFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompromisedCredentialsRiskConfigurationType)) {
            return false;
        }
        CompromisedCredentialsRiskConfigurationType other = (CompromisedCredentialsRiskConfigurationType)obj;
        return this.hasEventFilter() == other.hasEventFilter() && Objects.equals(this.eventFilterAsStrings(), other.eventFilterAsStrings()) && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"CompromisedCredentialsRiskConfigurationType").add("EventFilter", this.hasEventFilter() ? this.eventFilterAsStrings() : null).add("Actions", (Object)this.actions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventFilter": {
                return Optional.ofNullable(clazz.cast(this.eventFilterAsStrings()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompromisedCredentialsRiskConfigurationType, T> g) {
        return obj -> g.apply((CompromisedCredentialsRiskConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventFilter = DefaultSdkAutoConstructList.getInstance();
        private CompromisedCredentialsActionsType actions;

        private BuilderImpl() {
        }

        private BuilderImpl(CompromisedCredentialsRiskConfigurationType model) {
            this.eventFilterWithStrings(model.eventFilter);
            this.actions(model.actions);
        }

        public final Collection<String> getEventFilter() {
            if (this.eventFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventFilter;
        }

        public final void setEventFilter(Collection<String> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copy(eventFilter);
        }

        @Override
        @Transient
        public final Builder eventFilterWithStrings(Collection<String> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copy(eventFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventFilterWithStrings(String ... eventFilter) {
            this.eventFilterWithStrings(Arrays.asList(eventFilter));
            return this;
        }

        @Override
        @Transient
        public final Builder eventFilter(Collection<EventFilterType> eventFilter) {
            this.eventFilter = EventFiltersTypeCopier.copyEnumToString(eventFilter);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventFilter(EventFilterType ... eventFilter) {
            this.eventFilter(Arrays.asList(eventFilter));
            return this;
        }

        public final CompromisedCredentialsActionsType.Builder getActions() {
            return this.actions != null ? this.actions.toBuilder() : null;
        }

        public final void setActions(CompromisedCredentialsActionsType.BuilderImpl actions) {
            this.actions = actions != null ? actions.build() : null;
        }

        @Override
        @Transient
        public final Builder actions(CompromisedCredentialsActionsType actions) {
            this.actions = actions;
            return this;
        }

        public CompromisedCredentialsRiskConfigurationType build() {
            return new CompromisedCredentialsRiskConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompromisedCredentialsRiskConfigurationType> {
        public Builder eventFilterWithStrings(Collection<String> var1);

        public Builder eventFilterWithStrings(String ... var1);

        public Builder eventFilter(Collection<EventFilterType> var1);

        public Builder eventFilter(EventFilterType ... var1);

        public Builder actions(CompromisedCredentialsActionsType var1);

        default public Builder actions(Consumer<CompromisedCredentialsActionsType.Builder> actions) {
            return this.actions((CompromisedCredentialsActionsType)((CompromisedCredentialsActionsType.Builder)CompromisedCredentialsActionsType.builder().applyMutation(actions)).build());
        }
    }
}

