/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SmsMfaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolMfaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetUserPoolMfaConfigRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, SetUserPoolMfaConfigRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(SetUserPoolMfaConfigRequest.getter(SetUserPoolMfaConfigRequest::userPoolId)).setter(SetUserPoolMfaConfigRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<SmsMfaConfigType> SMS_MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmsMfaConfiguration").getter(SetUserPoolMfaConfigRequest.getter(SetUserPoolMfaConfigRequest::smsMfaConfiguration)).setter(SetUserPoolMfaConfigRequest.setter(Builder::smsMfaConfiguration)).constructor(SmsMfaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsMfaConfiguration").build()}).build();
    private static final SdkField<SoftwareTokenMfaConfigType> SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareTokenMfaConfiguration").getter(SetUserPoolMfaConfigRequest.getter(SetUserPoolMfaConfigRequest::softwareTokenMfaConfiguration)).setter(SetUserPoolMfaConfigRequest.setter(Builder::softwareTokenMfaConfiguration)).constructor(SoftwareTokenMfaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaConfiguration").build()}).build();
    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MfaConfiguration").getter(SetUserPoolMfaConfigRequest.getter(SetUserPoolMfaConfigRequest::mfaConfigurationAsString)).setter(SetUserPoolMfaConfigRequest.setter(Builder::mfaConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, SMS_MFA_CONFIGURATION_FIELD, SOFTWARE_TOKEN_MFA_CONFIGURATION_FIELD, MFA_CONFIGURATION_FIELD));
    private final String userPoolId;
    private final SmsMfaConfigType smsMfaConfiguration;
    private final SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;
    private final String mfaConfiguration;

    private SetUserPoolMfaConfigRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.smsMfaConfiguration = builder.smsMfaConfiguration;
        this.softwareTokenMfaConfiguration = builder.softwareTokenMfaConfiguration;
        this.mfaConfiguration = builder.mfaConfiguration;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final SmsMfaConfigType smsMfaConfiguration() {
        return this.smsMfaConfiguration;
    }

    public final SoftwareTokenMfaConfigType softwareTokenMfaConfiguration() {
        return this.softwareTokenMfaConfiguration;
    }

    public final UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(this.mfaConfiguration);
    }

    public final String mfaConfigurationAsString() {
        return this.mfaConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareTokenMfaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaConfigurationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetUserPoolMfaConfigRequest)) {
            return false;
        }
        SetUserPoolMfaConfigRequest other = (SetUserPoolMfaConfigRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.smsMfaConfiguration(), other.smsMfaConfiguration()) && Objects.equals(this.softwareTokenMfaConfiguration(), other.softwareTokenMfaConfiguration()) && Objects.equals(this.mfaConfigurationAsString(), other.mfaConfigurationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SetUserPoolMfaConfigRequest").add("UserPoolId", (Object)this.userPoolId()).add("SmsMfaConfiguration", (Object)this.smsMfaConfiguration()).add("SoftwareTokenMfaConfiguration", (Object)this.softwareTokenMfaConfiguration()).add("MfaConfiguration", (Object)this.mfaConfigurationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "SmsMfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.smsMfaConfiguration()));
            }
            case "SoftwareTokenMfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.softwareTokenMfaConfiguration()));
            }
            case "MfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mfaConfigurationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetUserPoolMfaConfigRequest, T> g) {
        return obj -> g.apply((SetUserPoolMfaConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private SmsMfaConfigType smsMfaConfiguration;
        private SoftwareTokenMfaConfigType softwareTokenMfaConfiguration;
        private String mfaConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SetUserPoolMfaConfigRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.smsMfaConfiguration(model.smsMfaConfiguration);
            this.softwareTokenMfaConfiguration(model.softwareTokenMfaConfiguration);
            this.mfaConfiguration(model.mfaConfiguration);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        @Transient
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final SmsMfaConfigType.Builder getSmsMfaConfiguration() {
            return this.smsMfaConfiguration != null ? this.smsMfaConfiguration.toBuilder() : null;
        }

        public final void setSmsMfaConfiguration(SmsMfaConfigType.BuilderImpl smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration != null ? smsMfaConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder smsMfaConfiguration(SmsMfaConfigType smsMfaConfiguration) {
            this.smsMfaConfiguration = smsMfaConfiguration;
            return this;
        }

        public final SoftwareTokenMfaConfigType.Builder getSoftwareTokenMfaConfiguration() {
            return this.softwareTokenMfaConfiguration != null ? this.softwareTokenMfaConfiguration.toBuilder() : null;
        }

        public final void setSoftwareTokenMfaConfiguration(SoftwareTokenMfaConfigType.BuilderImpl softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration != null ? softwareTokenMfaConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType softwareTokenMfaConfiguration) {
            this.softwareTokenMfaConfiguration = softwareTokenMfaConfiguration;
            return this;
        }

        public final String getMfaConfiguration() {
            return this.mfaConfiguration;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        @Override
        @Transient
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        @Transient
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetUserPoolMfaConfigRequest build() {
            return new SetUserPoolMfaConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetUserPoolMfaConfigRequest> {
        public Builder userPoolId(String var1);

        public Builder smsMfaConfiguration(SmsMfaConfigType var1);

        default public Builder smsMfaConfiguration(Consumer<SmsMfaConfigType.Builder> smsMfaConfiguration) {
            return this.smsMfaConfiguration((SmsMfaConfigType)((SmsMfaConfigType.Builder)SmsMfaConfigType.builder().applyMutation(smsMfaConfiguration)).build());
        }

        public Builder softwareTokenMfaConfiguration(SoftwareTokenMfaConfigType var1);

        default public Builder softwareTokenMfaConfiguration(Consumer<SoftwareTokenMfaConfigType.Builder> softwareTokenMfaConfiguration) {
            return this.softwareTokenMfaConfiguration((SoftwareTokenMfaConfigType)((SoftwareTokenMfaConfigType.Builder)SoftwareTokenMfaConfigType.builder().applyMutation(softwareTokenMfaConfiguration)).build());
        }

        public Builder mfaConfiguration(String var1);

        public Builder mfaConfiguration(UserPoolMfaType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

