/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AccountRecoverySettingType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminCreateUserConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AliasAttributesListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.DeviceConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EmailConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SchemaAttributesListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SmsConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolAddOnsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolMfaType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolPolicyType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolTagsTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameAttributesListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UsernameConfigurationType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerificationMessageTemplateType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.VerifiedAttributesListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPoolType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPoolType> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UserPoolType.getter(UserPoolType::id)).setter(UserPoolType.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UserPoolType.getter(UserPoolType::name)).setter(UserPoolType.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<UserPoolPolicyType> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Policies").getter(UserPoolType.getter(UserPoolType::policies)).setter(UserPoolType.setter(Builder::policies)).constructor(UserPoolPolicyType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build()}).build();
    private static final SdkField<LambdaConfigType> LAMBDA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaConfig").getter(UserPoolType.getter(UserPoolType::lambdaConfig)).setter(UserPoolType.setter(Builder::lambdaConfig)).constructor(LambdaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UserPoolType.getter(UserPoolType::statusAsString)).setter(UserPoolType.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(UserPoolType.getter(UserPoolType::lastModifiedDate)).setter(UserPoolType.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(UserPoolType.getter(UserPoolType::creationDate)).setter(UserPoolType.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<List<SchemaAttributeType>> SCHEMA_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SchemaAttributes").getter(UserPoolType.getter(UserPoolType::schemaAttributes)).setter(UserPoolType.setter(Builder::schemaAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaAttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTO_VERIFIED_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AutoVerifiedAttributes").getter(UserPoolType.getter(UserPoolType::autoVerifiedAttributesAsStrings)).setter(UserPoolType.setter(Builder::autoVerifiedAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoVerifiedAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALIAS_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AliasAttributes").getter(UserPoolType.getter(UserPoolType::aliasAttributesAsStrings)).setter(UserPoolType.setter(Builder::aliasAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USERNAME_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UsernameAttributes").getter(UserPoolType.getter(UserPoolType::usernameAttributesAsStrings)).setter(UserPoolType.setter(Builder::usernameAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SMS_VERIFICATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmsVerificationMessage").getter(UserPoolType.getter(UserPoolType::smsVerificationMessage)).setter(UserPoolType.setter(Builder::smsVerificationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsVerificationMessage").build()}).build();
    private static final SdkField<String> EMAIL_VERIFICATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailVerificationMessage").getter(UserPoolType.getter(UserPoolType::emailVerificationMessage)).setter(UserPoolType.setter(Builder::emailVerificationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationMessage").build()}).build();
    private static final SdkField<String> EMAIL_VERIFICATION_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailVerificationSubject").getter(UserPoolType.getter(UserPoolType::emailVerificationSubject)).setter(UserPoolType.setter(Builder::emailVerificationSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailVerificationSubject").build()}).build();
    private static final SdkField<VerificationMessageTemplateType> VERIFICATION_MESSAGE_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VerificationMessageTemplate").getter(UserPoolType.getter(UserPoolType::verificationMessageTemplate)).setter(UserPoolType.setter(Builder::verificationMessageTemplate)).constructor(VerificationMessageTemplateType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationMessageTemplate").build()}).build();
    private static final SdkField<String> SMS_AUTHENTICATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmsAuthenticationMessage").getter(UserPoolType.getter(UserPoolType::smsAuthenticationMessage)).setter(UserPoolType.setter(Builder::smsAuthenticationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsAuthenticationMessage").build()}).build();
    private static final SdkField<String> MFA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MfaConfiguration").getter(UserPoolType.getter(UserPoolType::mfaConfigurationAsString)).setter(UserPoolType.setter(Builder::mfaConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MfaConfiguration").build()}).build();
    private static final SdkField<DeviceConfigurationType> DEVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceConfiguration").getter(UserPoolType.getter(UserPoolType::deviceConfiguration)).setter(UserPoolType.setter(Builder::deviceConfiguration)).constructor(DeviceConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConfiguration").build()}).build();
    private static final SdkField<Integer> ESTIMATED_NUMBER_OF_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("EstimatedNumberOfUsers").getter(UserPoolType.getter(UserPoolType::estimatedNumberOfUsers)).setter(UserPoolType.setter(Builder::estimatedNumberOfUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedNumberOfUsers").build()}).build();
    private static final SdkField<EmailConfigurationType> EMAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmailConfiguration").getter(UserPoolType.getter(UserPoolType::emailConfiguration)).setter(UserPoolType.setter(Builder::emailConfiguration)).constructor(EmailConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailConfiguration").build()}).build();
    private static final SdkField<SmsConfigurationType> SMS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SmsConfiguration").getter(UserPoolType.getter(UserPoolType::smsConfiguration)).setter(UserPoolType.setter(Builder::smsConfiguration)).constructor(SmsConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> USER_POOL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("UserPoolTags").getter(UserPoolType.getter(UserPoolType::userPoolTags)).setter(UserPoolType.setter(Builder::userPoolTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SMS_CONFIGURATION_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmsConfigurationFailure").getter(UserPoolType.getter(UserPoolType::smsConfigurationFailure)).setter(UserPoolType.setter(Builder::smsConfigurationFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmsConfigurationFailure").build()}).build();
    private static final SdkField<String> EMAIL_CONFIGURATION_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailConfigurationFailure").getter(UserPoolType.getter(UserPoolType::emailConfigurationFailure)).setter(UserPoolType.setter(Builder::emailConfigurationFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailConfigurationFailure").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(UserPoolType.getter(UserPoolType::domain)).setter(UserPoolType.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDomain").getter(UserPoolType.getter(UserPoolType::customDomain)).setter(UserPoolType.setter(Builder::customDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()}).build();
    private static final SdkField<AdminCreateUserConfigType> ADMIN_CREATE_USER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdminCreateUserConfig").getter(UserPoolType.getter(UserPoolType::adminCreateUserConfig)).setter(UserPoolType.setter(Builder::adminCreateUserConfig)).constructor(AdminCreateUserConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminCreateUserConfig").build()}).build();
    private static final SdkField<UserPoolAddOnsType> USER_POOL_ADD_ONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserPoolAddOns").getter(UserPoolType.getter(UserPoolType::userPoolAddOns)).setter(UserPoolType.setter(Builder::userPoolAddOns)).constructor(UserPoolAddOnsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolAddOns").build()}).build();
    private static final SdkField<UsernameConfigurationType> USERNAME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UsernameConfiguration").getter(UserPoolType.getter(UserPoolType::usernameConfiguration)).setter(UserPoolType.setter(Builder::usernameConfiguration)).constructor(UsernameConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsernameConfiguration").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UserPoolType.getter(UserPoolType::arn)).setter(UserPoolType.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<AccountRecoverySettingType> ACCOUNT_RECOVERY_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountRecoverySetting").getter(UserPoolType.getter(UserPoolType::accountRecoverySetting)).setter(UserPoolType.setter(Builder::accountRecoverySetting)).constructor(AccountRecoverySettingType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountRecoverySetting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, POLICIES_FIELD, LAMBDA_CONFIG_FIELD, STATUS_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD, SCHEMA_ATTRIBUTES_FIELD, AUTO_VERIFIED_ATTRIBUTES_FIELD, ALIAS_ATTRIBUTES_FIELD, USERNAME_ATTRIBUTES_FIELD, SMS_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_MESSAGE_FIELD, EMAIL_VERIFICATION_SUBJECT_FIELD, VERIFICATION_MESSAGE_TEMPLATE_FIELD, SMS_AUTHENTICATION_MESSAGE_FIELD, MFA_CONFIGURATION_FIELD, DEVICE_CONFIGURATION_FIELD, ESTIMATED_NUMBER_OF_USERS_FIELD, EMAIL_CONFIGURATION_FIELD, SMS_CONFIGURATION_FIELD, USER_POOL_TAGS_FIELD, SMS_CONFIGURATION_FAILURE_FIELD, EMAIL_CONFIGURATION_FAILURE_FIELD, DOMAIN_FIELD, CUSTOM_DOMAIN_FIELD, ADMIN_CREATE_USER_CONFIG_FIELD, USER_POOL_ADD_ONS_FIELD, USERNAME_CONFIGURATION_FIELD, ARN_FIELD, ACCOUNT_RECOVERY_SETTING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final UserPoolPolicyType policies;
    private final LambdaConfigType lambdaConfig;
    private final String status;
    private final Instant lastModifiedDate;
    private final Instant creationDate;
    private final List<SchemaAttributeType> schemaAttributes;
    private final List<String> autoVerifiedAttributes;
    private final List<String> aliasAttributes;
    private final List<String> usernameAttributes;
    private final String smsVerificationMessage;
    private final String emailVerificationMessage;
    private final String emailVerificationSubject;
    private final VerificationMessageTemplateType verificationMessageTemplate;
    private final String smsAuthenticationMessage;
    private final String mfaConfiguration;
    private final DeviceConfigurationType deviceConfiguration;
    private final Integer estimatedNumberOfUsers;
    private final EmailConfigurationType emailConfiguration;
    private final SmsConfigurationType smsConfiguration;
    private final Map<String, String> userPoolTags;
    private final String smsConfigurationFailure;
    private final String emailConfigurationFailure;
    private final String domain;
    private final String customDomain;
    private final AdminCreateUserConfigType adminCreateUserConfig;
    private final UserPoolAddOnsType userPoolAddOns;
    private final UsernameConfigurationType usernameConfiguration;
    private final String arn;
    private final AccountRecoverySettingType accountRecoverySetting;

    private UserPoolType(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.policies = builder.policies;
        this.lambdaConfig = builder.lambdaConfig;
        this.status = builder.status;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
        this.schemaAttributes = builder.schemaAttributes;
        this.autoVerifiedAttributes = builder.autoVerifiedAttributes;
        this.aliasAttributes = builder.aliasAttributes;
        this.usernameAttributes = builder.usernameAttributes;
        this.smsVerificationMessage = builder.smsVerificationMessage;
        this.emailVerificationMessage = builder.emailVerificationMessage;
        this.emailVerificationSubject = builder.emailVerificationSubject;
        this.verificationMessageTemplate = builder.verificationMessageTemplate;
        this.smsAuthenticationMessage = builder.smsAuthenticationMessage;
        this.mfaConfiguration = builder.mfaConfiguration;
        this.deviceConfiguration = builder.deviceConfiguration;
        this.estimatedNumberOfUsers = builder.estimatedNumberOfUsers;
        this.emailConfiguration = builder.emailConfiguration;
        this.smsConfiguration = builder.smsConfiguration;
        this.userPoolTags = builder.userPoolTags;
        this.smsConfigurationFailure = builder.smsConfigurationFailure;
        this.emailConfigurationFailure = builder.emailConfigurationFailure;
        this.domain = builder.domain;
        this.customDomain = builder.customDomain;
        this.adminCreateUserConfig = builder.adminCreateUserConfig;
        this.userPoolAddOns = builder.userPoolAddOns;
        this.usernameConfiguration = builder.usernameConfiguration;
        this.arn = builder.arn;
        this.accountRecoverySetting = builder.accountRecoverySetting;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final UserPoolPolicyType policies() {
        return this.policies;
    }

    public final LambdaConfigType lambdaConfig() {
        return this.lambdaConfig;
    }

    public final StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final boolean hasSchemaAttributes() {
        return this.schemaAttributes != null && !(this.schemaAttributes instanceof SdkAutoConstructList);
    }

    public final List<SchemaAttributeType> schemaAttributes() {
        return this.schemaAttributes;
    }

    public final List<VerifiedAttributeType> autoVerifiedAttributes() {
        return VerifiedAttributesListTypeCopier.copyStringToEnum(this.autoVerifiedAttributes);
    }

    public final boolean hasAutoVerifiedAttributes() {
        return this.autoVerifiedAttributes != null && !(this.autoVerifiedAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> autoVerifiedAttributesAsStrings() {
        return this.autoVerifiedAttributes;
    }

    public final List<AliasAttributeType> aliasAttributes() {
        return AliasAttributesListTypeCopier.copyStringToEnum(this.aliasAttributes);
    }

    public final boolean hasAliasAttributes() {
        return this.aliasAttributes != null && !(this.aliasAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> aliasAttributesAsStrings() {
        return this.aliasAttributes;
    }

    public final List<UsernameAttributeType> usernameAttributes() {
        return UsernameAttributesListTypeCopier.copyStringToEnum(this.usernameAttributes);
    }

    public final boolean hasUsernameAttributes() {
        return this.usernameAttributes != null && !(this.usernameAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> usernameAttributesAsStrings() {
        return this.usernameAttributes;
    }

    public final String smsVerificationMessage() {
        return this.smsVerificationMessage;
    }

    public final String emailVerificationMessage() {
        return this.emailVerificationMessage;
    }

    public final String emailVerificationSubject() {
        return this.emailVerificationSubject;
    }

    public final VerificationMessageTemplateType verificationMessageTemplate() {
        return this.verificationMessageTemplate;
    }

    public final String smsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    public final UserPoolMfaType mfaConfiguration() {
        return UserPoolMfaType.fromValue(this.mfaConfiguration);
    }

    public final String mfaConfigurationAsString() {
        return this.mfaConfiguration;
    }

    public final DeviceConfigurationType deviceConfiguration() {
        return this.deviceConfiguration;
    }

    public final Integer estimatedNumberOfUsers() {
        return this.estimatedNumberOfUsers;
    }

    public final EmailConfigurationType emailConfiguration() {
        return this.emailConfiguration;
    }

    public final SmsConfigurationType smsConfiguration() {
        return this.smsConfiguration;
    }

    public final boolean hasUserPoolTags() {
        return this.userPoolTags != null && !(this.userPoolTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> userPoolTags() {
        return this.userPoolTags;
    }

    public final String smsConfigurationFailure() {
        return this.smsConfigurationFailure;
    }

    public final String emailConfigurationFailure() {
        return this.emailConfigurationFailure;
    }

    public final String domain() {
        return this.domain;
    }

    public final String customDomain() {
        return this.customDomain;
    }

    public final AdminCreateUserConfigType adminCreateUserConfig() {
        return this.adminCreateUserConfig;
    }

    public final UserPoolAddOnsType userPoolAddOns() {
        return this.userPoolAddOns;
    }

    public final UsernameConfigurationType usernameConfiguration() {
        return this.usernameConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final AccountRecoverySettingType accountRecoverySetting() {
        return this.accountRecoverySetting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.policies());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaAttributes() ? this.schemaAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoVerifiedAttributes() ? this.autoVerifiedAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliasAttributes() ? this.aliasAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsernameAttributes() ? this.usernameAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.smsVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailVerificationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailVerificationSubject());
        hashCode = 31 * hashCode + Objects.hashCode(this.verificationMessageTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsAuthenticationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaConfigurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedNumberOfUsers());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.smsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserPoolTags() ? this.userPoolTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.smsConfigurationFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailConfigurationFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminCreateUserConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolAddOns());
        hashCode = 31 * hashCode + Objects.hashCode(this.usernameConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountRecoverySetting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolType)) {
            return false;
        }
        UserPoolType other = (UserPoolType)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.lambdaConfig(), other.lambdaConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.creationDate(), other.creationDate()) && this.hasSchemaAttributes() == other.hasSchemaAttributes() && Objects.equals(this.schemaAttributes(), other.schemaAttributes()) && this.hasAutoVerifiedAttributes() == other.hasAutoVerifiedAttributes() && Objects.equals(this.autoVerifiedAttributesAsStrings(), other.autoVerifiedAttributesAsStrings()) && this.hasAliasAttributes() == other.hasAliasAttributes() && Objects.equals(this.aliasAttributesAsStrings(), other.aliasAttributesAsStrings()) && this.hasUsernameAttributes() == other.hasUsernameAttributes() && Objects.equals(this.usernameAttributesAsStrings(), other.usernameAttributesAsStrings()) && Objects.equals(this.smsVerificationMessage(), other.smsVerificationMessage()) && Objects.equals(this.emailVerificationMessage(), other.emailVerificationMessage()) && Objects.equals(this.emailVerificationSubject(), other.emailVerificationSubject()) && Objects.equals(this.verificationMessageTemplate(), other.verificationMessageTemplate()) && Objects.equals(this.smsAuthenticationMessage(), other.smsAuthenticationMessage()) && Objects.equals(this.mfaConfigurationAsString(), other.mfaConfigurationAsString()) && Objects.equals(this.deviceConfiguration(), other.deviceConfiguration()) && Objects.equals(this.estimatedNumberOfUsers(), other.estimatedNumberOfUsers()) && Objects.equals(this.emailConfiguration(), other.emailConfiguration()) && Objects.equals(this.smsConfiguration(), other.smsConfiguration()) && this.hasUserPoolTags() == other.hasUserPoolTags() && Objects.equals(this.userPoolTags(), other.userPoolTags()) && Objects.equals(this.smsConfigurationFailure(), other.smsConfigurationFailure()) && Objects.equals(this.emailConfigurationFailure(), other.emailConfigurationFailure()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.customDomain(), other.customDomain()) && Objects.equals(this.adminCreateUserConfig(), other.adminCreateUserConfig()) && Objects.equals(this.userPoolAddOns(), other.userPoolAddOns()) && Objects.equals(this.usernameConfiguration(), other.usernameConfiguration()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.accountRecoverySetting(), other.accountRecoverySetting());
    }

    public final String toString() {
        return ToString.builder((String)"UserPoolType").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Policies", (Object)this.policies()).add("LambdaConfig", (Object)this.lambdaConfig()).add("Status", (Object)this.statusAsString()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CreationDate", (Object)this.creationDate()).add("SchemaAttributes", this.hasSchemaAttributes() ? this.schemaAttributes() : null).add("AutoVerifiedAttributes", this.hasAutoVerifiedAttributes() ? this.autoVerifiedAttributesAsStrings() : null).add("AliasAttributes", this.hasAliasAttributes() ? this.aliasAttributesAsStrings() : null).add("UsernameAttributes", this.hasUsernameAttributes() ? this.usernameAttributesAsStrings() : null).add("SmsVerificationMessage", (Object)this.smsVerificationMessage()).add("EmailVerificationMessage", (Object)this.emailVerificationMessage()).add("EmailVerificationSubject", (Object)this.emailVerificationSubject()).add("VerificationMessageTemplate", (Object)this.verificationMessageTemplate()).add("SmsAuthenticationMessage", (Object)this.smsAuthenticationMessage()).add("MfaConfiguration", (Object)this.mfaConfigurationAsString()).add("DeviceConfiguration", (Object)this.deviceConfiguration()).add("EstimatedNumberOfUsers", (Object)this.estimatedNumberOfUsers()).add("EmailConfiguration", (Object)this.emailConfiguration()).add("SmsConfiguration", (Object)this.smsConfiguration()).add("UserPoolTags", this.hasUserPoolTags() ? this.userPoolTags() : null).add("SmsConfigurationFailure", (Object)this.smsConfigurationFailure()).add("EmailConfigurationFailure", (Object)this.emailConfigurationFailure()).add("Domain", (Object)this.domain()).add("CustomDomain", (Object)this.customDomain()).add("AdminCreateUserConfig", (Object)this.adminCreateUserConfig()).add("UserPoolAddOns", (Object)this.userPoolAddOns()).add("UsernameConfiguration", (Object)this.usernameConfiguration()).add("Arn", (Object)this.arn()).add("AccountRecoverySetting", (Object)this.accountRecoverySetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "LambdaConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "SchemaAttributes": {
                return Optional.ofNullable(clazz.cast(this.schemaAttributes()));
            }
            case "AutoVerifiedAttributes": {
                return Optional.ofNullable(clazz.cast(this.autoVerifiedAttributesAsStrings()));
            }
            case "AliasAttributes": {
                return Optional.ofNullable(clazz.cast(this.aliasAttributesAsStrings()));
            }
            case "UsernameAttributes": {
                return Optional.ofNullable(clazz.cast(this.usernameAttributesAsStrings()));
            }
            case "SmsVerificationMessage": {
                return Optional.ofNullable(clazz.cast(this.smsVerificationMessage()));
            }
            case "EmailVerificationMessage": {
                return Optional.ofNullable(clazz.cast(this.emailVerificationMessage()));
            }
            case "EmailVerificationSubject": {
                return Optional.ofNullable(clazz.cast(this.emailVerificationSubject()));
            }
            case "VerificationMessageTemplate": {
                return Optional.ofNullable(clazz.cast(this.verificationMessageTemplate()));
            }
            case "SmsAuthenticationMessage": {
                return Optional.ofNullable(clazz.cast(this.smsAuthenticationMessage()));
            }
            case "MfaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.mfaConfigurationAsString()));
            }
            case "DeviceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.deviceConfiguration()));
            }
            case "EstimatedNumberOfUsers": {
                return Optional.ofNullable(clazz.cast(this.estimatedNumberOfUsers()));
            }
            case "EmailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.emailConfiguration()));
            }
            case "SmsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.smsConfiguration()));
            }
            case "UserPoolTags": {
                return Optional.ofNullable(clazz.cast(this.userPoolTags()));
            }
            case "SmsConfigurationFailure": {
                return Optional.ofNullable(clazz.cast(this.smsConfigurationFailure()));
            }
            case "EmailConfigurationFailure": {
                return Optional.ofNullable(clazz.cast(this.emailConfigurationFailure()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "CustomDomain": {
                return Optional.ofNullable(clazz.cast(this.customDomain()));
            }
            case "AdminCreateUserConfig": {
                return Optional.ofNullable(clazz.cast(this.adminCreateUserConfig()));
            }
            case "UserPoolAddOns": {
                return Optional.ofNullable(clazz.cast(this.userPoolAddOns()));
            }
            case "UsernameConfiguration": {
                return Optional.ofNullable(clazz.cast(this.usernameConfiguration()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AccountRecoverySetting": {
                return Optional.ofNullable(clazz.cast(this.accountRecoverySetting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolType, T> g) {
        return obj -> g.apply((UserPoolType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private UserPoolPolicyType policies;
        private LambdaConfigType lambdaConfig;
        private String status;
        private Instant lastModifiedDate;
        private Instant creationDate;
        private List<SchemaAttributeType> schemaAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> autoVerifiedAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> aliasAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<String> usernameAttributes = DefaultSdkAutoConstructList.getInstance();
        private String smsVerificationMessage;
        private String emailVerificationMessage;
        private String emailVerificationSubject;
        private VerificationMessageTemplateType verificationMessageTemplate;
        private String smsAuthenticationMessage;
        private String mfaConfiguration;
        private DeviceConfigurationType deviceConfiguration;
        private Integer estimatedNumberOfUsers;
        private EmailConfigurationType emailConfiguration;
        private SmsConfigurationType smsConfiguration;
        private Map<String, String> userPoolTags = DefaultSdkAutoConstructMap.getInstance();
        private String smsConfigurationFailure;
        private String emailConfigurationFailure;
        private String domain;
        private String customDomain;
        private AdminCreateUserConfigType adminCreateUserConfig;
        private UserPoolAddOnsType userPoolAddOns;
        private UsernameConfigurationType usernameConfiguration;
        private String arn;
        private AccountRecoverySettingType accountRecoverySetting;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolType model) {
            this.id(model.id);
            this.name(model.name);
            this.policies(model.policies);
            this.lambdaConfig(model.lambdaConfig);
            this.status(model.status);
            this.lastModifiedDate(model.lastModifiedDate);
            this.creationDate(model.creationDate);
            this.schemaAttributes(model.schemaAttributes);
            this.autoVerifiedAttributesWithStrings(model.autoVerifiedAttributes);
            this.aliasAttributesWithStrings(model.aliasAttributes);
            this.usernameAttributesWithStrings(model.usernameAttributes);
            this.smsVerificationMessage(model.smsVerificationMessage);
            this.emailVerificationMessage(model.emailVerificationMessage);
            this.emailVerificationSubject(model.emailVerificationSubject);
            this.verificationMessageTemplate(model.verificationMessageTemplate);
            this.smsAuthenticationMessage(model.smsAuthenticationMessage);
            this.mfaConfiguration(model.mfaConfiguration);
            this.deviceConfiguration(model.deviceConfiguration);
            this.estimatedNumberOfUsers(model.estimatedNumberOfUsers);
            this.emailConfiguration(model.emailConfiguration);
            this.smsConfiguration(model.smsConfiguration);
            this.userPoolTags(model.userPoolTags);
            this.smsConfigurationFailure(model.smsConfigurationFailure);
            this.emailConfigurationFailure(model.emailConfigurationFailure);
            this.domain(model.domain);
            this.customDomain(model.customDomain);
            this.adminCreateUserConfig(model.adminCreateUserConfig);
            this.userPoolAddOns(model.userPoolAddOns);
            this.usernameConfiguration(model.usernameConfiguration);
            this.arn(model.arn);
            this.accountRecoverySetting(model.accountRecoverySetting);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final UserPoolPolicyType.Builder getPolicies() {
            return this.policies != null ? this.policies.toBuilder() : null;
        }

        public final void setPolicies(UserPoolPolicyType.BuilderImpl policies) {
            this.policies = policies != null ? policies.build() : null;
        }

        @Override
        @Transient
        public final Builder policies(UserPoolPolicyType policies) {
            this.policies = policies;
            return this;
        }

        public final LambdaConfigType.Builder getLambdaConfig() {
            return this.lambdaConfig != null ? this.lambdaConfig.toBuilder() : null;
        }

        public final void setLambdaConfig(LambdaConfigType.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaConfig(LambdaConfigType lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final List<SchemaAttributeType.Builder> getSchemaAttributes() {
            List<SchemaAttributeType.Builder> result = SchemaAttributesListTypeCopier.copyToBuilder(this.schemaAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaAttributes(Collection<SchemaAttributeType.BuilderImpl> schemaAttributes) {
            this.schemaAttributes = SchemaAttributesListTypeCopier.copyFromBuilder(schemaAttributes);
        }

        @Override
        @Transient
        public final Builder schemaAttributes(Collection<SchemaAttributeType> schemaAttributes) {
            this.schemaAttributes = SchemaAttributesListTypeCopier.copy(schemaAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder schemaAttributes(SchemaAttributeType ... schemaAttributes) {
            this.schemaAttributes(Arrays.asList(schemaAttributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder schemaAttributes(Consumer<SchemaAttributeType.Builder> ... schemaAttributes) {
            this.schemaAttributes(Stream.of(schemaAttributes).map(c -> (SchemaAttributeType)((SchemaAttributeType.Builder)SchemaAttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAutoVerifiedAttributes() {
            if (this.autoVerifiedAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoVerifiedAttributes;
        }

        public final void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
        }

        @Override
        @Transient
        public final Builder autoVerifiedAttributesWithStrings(Collection<String> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copy(autoVerifiedAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoVerifiedAttributesWithStrings(String ... autoVerifiedAttributes) {
            this.autoVerifiedAttributesWithStrings(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        @Override
        @Transient
        public final Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> autoVerifiedAttributes) {
            this.autoVerifiedAttributes = VerifiedAttributesListTypeCopier.copyEnumToString(autoVerifiedAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoVerifiedAttributes(VerifiedAttributeType ... autoVerifiedAttributes) {
            this.autoVerifiedAttributes(Arrays.asList(autoVerifiedAttributes));
            return this;
        }

        public final Collection<String> getAliasAttributes() {
            if (this.aliasAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aliasAttributes;
        }

        public final void setAliasAttributes(Collection<String> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copy(aliasAttributes);
        }

        @Override
        @Transient
        public final Builder aliasAttributesWithStrings(Collection<String> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copy(aliasAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder aliasAttributesWithStrings(String ... aliasAttributes) {
            this.aliasAttributesWithStrings(Arrays.asList(aliasAttributes));
            return this;
        }

        @Override
        @Transient
        public final Builder aliasAttributes(Collection<AliasAttributeType> aliasAttributes) {
            this.aliasAttributes = AliasAttributesListTypeCopier.copyEnumToString(aliasAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder aliasAttributes(AliasAttributeType ... aliasAttributes) {
            this.aliasAttributes(Arrays.asList(aliasAttributes));
            return this;
        }

        public final Collection<String> getUsernameAttributes() {
            if (this.usernameAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.usernameAttributes;
        }

        public final void setUsernameAttributes(Collection<String> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copy(usernameAttributes);
        }

        @Override
        @Transient
        public final Builder usernameAttributesWithStrings(Collection<String> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copy(usernameAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder usernameAttributesWithStrings(String ... usernameAttributes) {
            this.usernameAttributesWithStrings(Arrays.asList(usernameAttributes));
            return this;
        }

        @Override
        @Transient
        public final Builder usernameAttributes(Collection<UsernameAttributeType> usernameAttributes) {
            this.usernameAttributes = UsernameAttributesListTypeCopier.copyEnumToString(usernameAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder usernameAttributes(UsernameAttributeType ... usernameAttributes) {
            this.usernameAttributes(Arrays.asList(usernameAttributes));
            return this;
        }

        public final String getSmsVerificationMessage() {
            return this.smsVerificationMessage;
        }

        public final void setSmsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
        }

        @Override
        @Transient
        public final Builder smsVerificationMessage(String smsVerificationMessage) {
            this.smsVerificationMessage = smsVerificationMessage;
            return this;
        }

        public final String getEmailVerificationMessage() {
            return this.emailVerificationMessage;
        }

        public final void setEmailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
        }

        @Override
        @Transient
        public final Builder emailVerificationMessage(String emailVerificationMessage) {
            this.emailVerificationMessage = emailVerificationMessage;
            return this;
        }

        public final String getEmailVerificationSubject() {
            return this.emailVerificationSubject;
        }

        public final void setEmailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
        }

        @Override
        @Transient
        public final Builder emailVerificationSubject(String emailVerificationSubject) {
            this.emailVerificationSubject = emailVerificationSubject;
            return this;
        }

        public final VerificationMessageTemplateType.Builder getVerificationMessageTemplate() {
            return this.verificationMessageTemplate != null ? this.verificationMessageTemplate.toBuilder() : null;
        }

        public final void setVerificationMessageTemplate(VerificationMessageTemplateType.BuilderImpl verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate != null ? verificationMessageTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder verificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
            this.verificationMessageTemplate = verificationMessageTemplate;
            return this;
        }

        public final String getSmsAuthenticationMessage() {
            return this.smsAuthenticationMessage;
        }

        public final void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
        }

        @Override
        @Transient
        public final Builder smsAuthenticationMessage(String smsAuthenticationMessage) {
            this.smsAuthenticationMessage = smsAuthenticationMessage;
            return this;
        }

        public final String getMfaConfiguration() {
            return this.mfaConfiguration;
        }

        public final void setMfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
        }

        @Override
        @Transient
        public final Builder mfaConfiguration(String mfaConfiguration) {
            this.mfaConfiguration = mfaConfiguration;
            return this;
        }

        @Override
        @Transient
        public final Builder mfaConfiguration(UserPoolMfaType mfaConfiguration) {
            this.mfaConfiguration(mfaConfiguration == null ? null : mfaConfiguration.toString());
            return this;
        }

        public final DeviceConfigurationType.Builder getDeviceConfiguration() {
            return this.deviceConfiguration != null ? this.deviceConfiguration.toBuilder() : null;
        }

        public final void setDeviceConfiguration(DeviceConfigurationType.BuilderImpl deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration != null ? deviceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder deviceConfiguration(DeviceConfigurationType deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            return this;
        }

        public final Integer getEstimatedNumberOfUsers() {
            return this.estimatedNumberOfUsers;
        }

        public final void setEstimatedNumberOfUsers(Integer estimatedNumberOfUsers) {
            this.estimatedNumberOfUsers = estimatedNumberOfUsers;
        }

        @Override
        @Transient
        public final Builder estimatedNumberOfUsers(Integer estimatedNumberOfUsers) {
            this.estimatedNumberOfUsers = estimatedNumberOfUsers;
            return this;
        }

        public final EmailConfigurationType.Builder getEmailConfiguration() {
            return this.emailConfiguration != null ? this.emailConfiguration.toBuilder() : null;
        }

        public final void setEmailConfiguration(EmailConfigurationType.BuilderImpl emailConfiguration) {
            this.emailConfiguration = emailConfiguration != null ? emailConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder emailConfiguration(EmailConfigurationType emailConfiguration) {
            this.emailConfiguration = emailConfiguration;
            return this;
        }

        public final SmsConfigurationType.Builder getSmsConfiguration() {
            return this.smsConfiguration != null ? this.smsConfiguration.toBuilder() : null;
        }

        public final void setSmsConfiguration(SmsConfigurationType.BuilderImpl smsConfiguration) {
            this.smsConfiguration = smsConfiguration != null ? smsConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder smsConfiguration(SmsConfigurationType smsConfiguration) {
            this.smsConfiguration = smsConfiguration;
            return this;
        }

        public final Map<String, String> getUserPoolTags() {
            if (this.userPoolTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.userPoolTags;
        }

        public final void setUserPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
        }

        @Override
        @Transient
        public final Builder userPoolTags(Map<String, String> userPoolTags) {
            this.userPoolTags = UserPoolTagsTypeCopier.copy(userPoolTags);
            return this;
        }

        public final String getSmsConfigurationFailure() {
            return this.smsConfigurationFailure;
        }

        public final void setSmsConfigurationFailure(String smsConfigurationFailure) {
            this.smsConfigurationFailure = smsConfigurationFailure;
        }

        @Override
        @Transient
        public final Builder smsConfigurationFailure(String smsConfigurationFailure) {
            this.smsConfigurationFailure = smsConfigurationFailure;
            return this;
        }

        public final String getEmailConfigurationFailure() {
            return this.emailConfigurationFailure;
        }

        public final void setEmailConfigurationFailure(String emailConfigurationFailure) {
            this.emailConfigurationFailure = emailConfigurationFailure;
        }

        @Override
        @Transient
        public final Builder emailConfigurationFailure(String emailConfigurationFailure) {
            this.emailConfigurationFailure = emailConfigurationFailure;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getCustomDomain() {
            return this.customDomain;
        }

        public final void setCustomDomain(String customDomain) {
            this.customDomain = customDomain;
        }

        @Override
        @Transient
        public final Builder customDomain(String customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        public final AdminCreateUserConfigType.Builder getAdminCreateUserConfig() {
            return this.adminCreateUserConfig != null ? this.adminCreateUserConfig.toBuilder() : null;
        }

        public final void setAdminCreateUserConfig(AdminCreateUserConfigType.BuilderImpl adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig != null ? adminCreateUserConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder adminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
            this.adminCreateUserConfig = adminCreateUserConfig;
            return this;
        }

        public final UserPoolAddOnsType.Builder getUserPoolAddOns() {
            return this.userPoolAddOns != null ? this.userPoolAddOns.toBuilder() : null;
        }

        public final void setUserPoolAddOns(UserPoolAddOnsType.BuilderImpl userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns != null ? userPoolAddOns.build() : null;
        }

        @Override
        @Transient
        public final Builder userPoolAddOns(UserPoolAddOnsType userPoolAddOns) {
            this.userPoolAddOns = userPoolAddOns;
            return this;
        }

        public final UsernameConfigurationType.Builder getUsernameConfiguration() {
            return this.usernameConfiguration != null ? this.usernameConfiguration.toBuilder() : null;
        }

        public final void setUsernameConfiguration(UsernameConfigurationType.BuilderImpl usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration != null ? usernameConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder usernameConfiguration(UsernameConfigurationType usernameConfiguration) {
            this.usernameConfiguration = usernameConfiguration;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AccountRecoverySettingType.Builder getAccountRecoverySetting() {
            return this.accountRecoverySetting != null ? this.accountRecoverySetting.toBuilder() : null;
        }

        public final void setAccountRecoverySetting(AccountRecoverySettingType.BuilderImpl accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting != null ? accountRecoverySetting.build() : null;
        }

        @Override
        @Transient
        public final Builder accountRecoverySetting(AccountRecoverySettingType accountRecoverySetting) {
            this.accountRecoverySetting = accountRecoverySetting;
            return this;
        }

        public UserPoolType build() {
            return new UserPoolType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPoolType> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder policies(UserPoolPolicyType var1);

        default public Builder policies(Consumer<UserPoolPolicyType.Builder> policies) {
            return this.policies((UserPoolPolicyType)((UserPoolPolicyType.Builder)UserPoolPolicyType.builder().applyMutation(policies)).build());
        }

        public Builder lambdaConfig(LambdaConfigType var1);

        default public Builder lambdaConfig(Consumer<LambdaConfigType.Builder> lambdaConfig) {
            return this.lambdaConfig((LambdaConfigType)((LambdaConfigType.Builder)LambdaConfigType.builder().applyMutation(lambdaConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder creationDate(Instant var1);

        public Builder schemaAttributes(Collection<SchemaAttributeType> var1);

        public Builder schemaAttributes(SchemaAttributeType ... var1);

        public Builder schemaAttributes(Consumer<SchemaAttributeType.Builder> ... var1);

        public Builder autoVerifiedAttributesWithStrings(Collection<String> var1);

        public Builder autoVerifiedAttributesWithStrings(String ... var1);

        public Builder autoVerifiedAttributes(Collection<VerifiedAttributeType> var1);

        public Builder autoVerifiedAttributes(VerifiedAttributeType ... var1);

        public Builder aliasAttributesWithStrings(Collection<String> var1);

        public Builder aliasAttributesWithStrings(String ... var1);

        public Builder aliasAttributes(Collection<AliasAttributeType> var1);

        public Builder aliasAttributes(AliasAttributeType ... var1);

        public Builder usernameAttributesWithStrings(Collection<String> var1);

        public Builder usernameAttributesWithStrings(String ... var1);

        public Builder usernameAttributes(Collection<UsernameAttributeType> var1);

        public Builder usernameAttributes(UsernameAttributeType ... var1);

        public Builder smsVerificationMessage(String var1);

        public Builder emailVerificationMessage(String var1);

        public Builder emailVerificationSubject(String var1);

        public Builder verificationMessageTemplate(VerificationMessageTemplateType var1);

        default public Builder verificationMessageTemplate(Consumer<VerificationMessageTemplateType.Builder> verificationMessageTemplate) {
            return this.verificationMessageTemplate((VerificationMessageTemplateType)((VerificationMessageTemplateType.Builder)VerificationMessageTemplateType.builder().applyMutation(verificationMessageTemplate)).build());
        }

        public Builder smsAuthenticationMessage(String var1);

        public Builder mfaConfiguration(String var1);

        public Builder mfaConfiguration(UserPoolMfaType var1);

        public Builder deviceConfiguration(DeviceConfigurationType var1);

        default public Builder deviceConfiguration(Consumer<DeviceConfigurationType.Builder> deviceConfiguration) {
            return this.deviceConfiguration((DeviceConfigurationType)((DeviceConfigurationType.Builder)DeviceConfigurationType.builder().applyMutation(deviceConfiguration)).build());
        }

        public Builder estimatedNumberOfUsers(Integer var1);

        public Builder emailConfiguration(EmailConfigurationType var1);

        default public Builder emailConfiguration(Consumer<EmailConfigurationType.Builder> emailConfiguration) {
            return this.emailConfiguration((EmailConfigurationType)((EmailConfigurationType.Builder)EmailConfigurationType.builder().applyMutation(emailConfiguration)).build());
        }

        public Builder smsConfiguration(SmsConfigurationType var1);

        default public Builder smsConfiguration(Consumer<SmsConfigurationType.Builder> smsConfiguration) {
            return this.smsConfiguration((SmsConfigurationType)((SmsConfigurationType.Builder)SmsConfigurationType.builder().applyMutation(smsConfiguration)).build());
        }

        public Builder userPoolTags(Map<String, String> var1);

        public Builder smsConfigurationFailure(String var1);

        public Builder emailConfigurationFailure(String var1);

        public Builder domain(String var1);

        public Builder customDomain(String var1);

        public Builder adminCreateUserConfig(AdminCreateUserConfigType var1);

        default public Builder adminCreateUserConfig(Consumer<AdminCreateUserConfigType.Builder> adminCreateUserConfig) {
            return this.adminCreateUserConfig((AdminCreateUserConfigType)((AdminCreateUserConfigType.Builder)AdminCreateUserConfigType.builder().applyMutation(adminCreateUserConfig)).build());
        }

        public Builder userPoolAddOns(UserPoolAddOnsType var1);

        default public Builder userPoolAddOns(Consumer<UserPoolAddOnsType.Builder> userPoolAddOns) {
            return this.userPoolAddOns((UserPoolAddOnsType)((UserPoolAddOnsType.Builder)UserPoolAddOnsType.builder().applyMutation(userPoolAddOns)).build());
        }

        public Builder usernameConfiguration(UsernameConfigurationType var1);

        default public Builder usernameConfiguration(Consumer<UsernameConfigurationType.Builder> usernameConfiguration) {
            return this.usernameConfiguration((UsernameConfigurationType)((UsernameConfigurationType.Builder)UsernameConfigurationType.builder().applyMutation(usernameConfiguration)).build());
        }

        public Builder arn(String var1);

        public Builder accountRecoverySetting(AccountRecoverySettingType var1);

        default public Builder accountRecoverySetting(Consumer<AccountRecoverySettingType.Builder> accountRecoverySetting) {
            return this.accountRecoverySetting((AccountRecoverySettingType)((AccountRecoverySettingType.Builder)AccountRecoverySettingType.builder().applyMutation(accountRecoverySetting)).build());
        }
    }
}

