/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PasswordPolicyType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PasswordPolicyType> {
    private static final SdkField<Integer> MINIMUM_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinimumLength").getter(PasswordPolicyType.getter(PasswordPolicyType::minimumLength)).setter(PasswordPolicyType.setter(Builder::minimumLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLength").build()}).build();
    private static final SdkField<Boolean> REQUIRE_UPPERCASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireUppercase").getter(PasswordPolicyType.getter(PasswordPolicyType::requireUppercase)).setter(PasswordPolicyType.setter(Builder::requireUppercase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireUppercase").build()}).build();
    private static final SdkField<Boolean> REQUIRE_LOWERCASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireLowercase").getter(PasswordPolicyType.getter(PasswordPolicyType::requireLowercase)).setter(PasswordPolicyType.setter(Builder::requireLowercase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireLowercase").build()}).build();
    private static final SdkField<Boolean> REQUIRE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireNumbers").getter(PasswordPolicyType.getter(PasswordPolicyType::requireNumbers)).setter(PasswordPolicyType.setter(Builder::requireNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireNumbers").build()}).build();
    private static final SdkField<Boolean> REQUIRE_SYMBOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireSymbols").getter(PasswordPolicyType.getter(PasswordPolicyType::requireSymbols)).setter(PasswordPolicyType.setter(Builder::requireSymbols)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireSymbols").build()}).build();
    private static final SdkField<Integer> TEMPORARY_PASSWORD_VALIDITY_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TemporaryPasswordValidityDays").getter(PasswordPolicyType.getter(PasswordPolicyType::temporaryPasswordValidityDays)).setter(PasswordPolicyType.setter(Builder::temporaryPasswordValidityDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporaryPasswordValidityDays").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_LENGTH_FIELD, REQUIRE_UPPERCASE_FIELD, REQUIRE_LOWERCASE_FIELD, REQUIRE_NUMBERS_FIELD, REQUIRE_SYMBOLS_FIELD, TEMPORARY_PASSWORD_VALIDITY_DAYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minimumLength;
    private final Boolean requireUppercase;
    private final Boolean requireLowercase;
    private final Boolean requireNumbers;
    private final Boolean requireSymbols;
    private final Integer temporaryPasswordValidityDays;

    private PasswordPolicyType(BuilderImpl builder) {
        this.minimumLength = builder.minimumLength;
        this.requireUppercase = builder.requireUppercase;
        this.requireLowercase = builder.requireLowercase;
        this.requireNumbers = builder.requireNumbers;
        this.requireSymbols = builder.requireSymbols;
        this.temporaryPasswordValidityDays = builder.temporaryPasswordValidityDays;
    }

    public Integer minimumLength() {
        return this.minimumLength;
    }

    public Boolean requireUppercase() {
        return this.requireUppercase;
    }

    public Boolean requireLowercase() {
        return this.requireLowercase;
    }

    public Boolean requireNumbers() {
        return this.requireNumbers;
    }

    public Boolean requireSymbols() {
        return this.requireSymbols;
    }

    public Integer temporaryPasswordValidityDays() {
        return this.temporaryPasswordValidityDays;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireUppercase());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireLowercase());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireSymbols());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporaryPasswordValidityDays());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PasswordPolicyType)) {
            return false;
        }
        PasswordPolicyType other = (PasswordPolicyType)obj;
        return Objects.equals(this.minimumLength(), other.minimumLength()) && Objects.equals(this.requireUppercase(), other.requireUppercase()) && Objects.equals(this.requireLowercase(), other.requireLowercase()) && Objects.equals(this.requireNumbers(), other.requireNumbers()) && Objects.equals(this.requireSymbols(), other.requireSymbols()) && Objects.equals(this.temporaryPasswordValidityDays(), other.temporaryPasswordValidityDays());
    }

    public String toString() {
        return ToString.builder((String)"PasswordPolicyType").add("MinimumLength", (Object)this.minimumLength()).add("RequireUppercase", (Object)this.requireUppercase()).add("RequireLowercase", (Object)this.requireLowercase()).add("RequireNumbers", (Object)this.requireNumbers()).add("RequireSymbols", (Object)this.requireSymbols()).add("TemporaryPasswordValidityDays", (Object)this.temporaryPasswordValidityDays()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumLength": {
                return Optional.ofNullable(clazz.cast(this.minimumLength()));
            }
            case "RequireUppercase": {
                return Optional.ofNullable(clazz.cast(this.requireUppercase()));
            }
            case "RequireLowercase": {
                return Optional.ofNullable(clazz.cast(this.requireLowercase()));
            }
            case "RequireNumbers": {
                return Optional.ofNullable(clazz.cast(this.requireNumbers()));
            }
            case "RequireSymbols": {
                return Optional.ofNullable(clazz.cast(this.requireSymbols()));
            }
            case "TemporaryPasswordValidityDays": {
                return Optional.ofNullable(clazz.cast(this.temporaryPasswordValidityDays()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PasswordPolicyType, T> g) {
        return obj -> g.apply((PasswordPolicyType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minimumLength;
        private Boolean requireUppercase;
        private Boolean requireLowercase;
        private Boolean requireNumbers;
        private Boolean requireSymbols;
        private Integer temporaryPasswordValidityDays;

        private BuilderImpl() {
        }

        private BuilderImpl(PasswordPolicyType model) {
            this.minimumLength(model.minimumLength);
            this.requireUppercase(model.requireUppercase);
            this.requireLowercase(model.requireLowercase);
            this.requireNumbers(model.requireNumbers);
            this.requireSymbols(model.requireSymbols);
            this.temporaryPasswordValidityDays(model.temporaryPasswordValidityDays);
        }

        public final Integer getMinimumLength() {
            return this.minimumLength;
        }

        @Override
        public final Builder minimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
            return this;
        }

        public final void setMinimumLength(Integer minimumLength) {
            this.minimumLength = minimumLength;
        }

        public final Boolean getRequireUppercase() {
            return this.requireUppercase;
        }

        @Override
        public final Builder requireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
            return this;
        }

        public final void setRequireUppercase(Boolean requireUppercase) {
            this.requireUppercase = requireUppercase;
        }

        public final Boolean getRequireLowercase() {
            return this.requireLowercase;
        }

        @Override
        public final Builder requireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
            return this;
        }

        public final void setRequireLowercase(Boolean requireLowercase) {
            this.requireLowercase = requireLowercase;
        }

        public final Boolean getRequireNumbers() {
            return this.requireNumbers;
        }

        @Override
        public final Builder requireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
            return this;
        }

        public final void setRequireNumbers(Boolean requireNumbers) {
            this.requireNumbers = requireNumbers;
        }

        public final Boolean getRequireSymbols() {
            return this.requireSymbols;
        }

        @Override
        public final Builder requireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
            return this;
        }

        public final void setRequireSymbols(Boolean requireSymbols) {
            this.requireSymbols = requireSymbols;
        }

        public final Integer getTemporaryPasswordValidityDays() {
            return this.temporaryPasswordValidityDays;
        }

        @Override
        public final Builder temporaryPasswordValidityDays(Integer temporaryPasswordValidityDays) {
            this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
            return this;
        }

        public final void setTemporaryPasswordValidityDays(Integer temporaryPasswordValidityDays) {
            this.temporaryPasswordValidityDays = temporaryPasswordValidityDays;
        }

        public PasswordPolicyType build() {
            return new PasswordPolicyType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PasswordPolicyType> {
        public Builder minimumLength(Integer var1);

        public Builder requireUppercase(Boolean var1);

        public Builder requireLowercase(Boolean var1);

        public Builder requireNumbers(Boolean var1);

        public Builder requireSymbols(Boolean var1);

        public Builder temporaryPasswordValidityDays(Integer var1);
    }
}

