/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AttributeType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionListTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.MFAOptionType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserMFASettingListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUserResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, GetUserResponse> {
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(GetUserResponse.getter(GetUserResponse::username)).setter(GetUserResponse.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<List<AttributeType>> USER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserAttributes").getter(GetUserResponse.getter(GetUserResponse::userAttributes)).setter(GetUserResponse.setter(Builder::userAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MFAOptionType>> MFA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MFAOptions").getter(GetUserResponse.getter(GetUserResponse::mfaOptions)).setter(GetUserResponse.setter(Builder::mfaOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MFAOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MFAOptionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_MFA_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMfaSetting").getter(GetUserResponse.getter(GetUserResponse::preferredMfaSetting)).setter(GetUserResponse.setter(Builder::preferredMfaSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMfaSetting").build()}).build();
    private static final SdkField<List<String>> USER_MFA_SETTING_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserMFASettingList").getter(GetUserResponse.getter(GetUserResponse::userMFASettingList)).setter(GetUserResponse.setter(Builder::userMFASettingList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMFASettingList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAME_FIELD, USER_ATTRIBUTES_FIELD, MFA_OPTIONS_FIELD, PREFERRED_MFA_SETTING_FIELD, USER_MFA_SETTING_LIST_FIELD));
    private final String username;
    private final List<AttributeType> userAttributes;
    private final List<MFAOptionType> mfaOptions;
    private final String preferredMfaSetting;
    private final List<String> userMFASettingList;

    private GetUserResponse(BuilderImpl builder) {
        super(builder);
        this.username = builder.username;
        this.userAttributes = builder.userAttributes;
        this.mfaOptions = builder.mfaOptions;
        this.preferredMfaSetting = builder.preferredMfaSetting;
        this.userMFASettingList = builder.userMFASettingList;
    }

    public String username() {
        return this.username;
    }

    public boolean hasUserAttributes() {
        return this.userAttributes != null && !(this.userAttributes instanceof SdkAutoConstructList);
    }

    public List<AttributeType> userAttributes() {
        return this.userAttributes;
    }

    public boolean hasMfaOptions() {
        return this.mfaOptions != null && !(this.mfaOptions instanceof SdkAutoConstructList);
    }

    public List<MFAOptionType> mfaOptions() {
        return this.mfaOptions;
    }

    public String preferredMfaSetting() {
        return this.preferredMfaSetting;
    }

    public boolean hasUserMFASettingList() {
        return this.userMFASettingList != null && !(this.userMFASettingList instanceof SdkAutoConstructList);
    }

    public List<String> userMFASettingList() {
        return this.userMFASettingList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserAttributes() ? this.userAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMfaOptions() ? this.mfaOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMfaSetting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserMFASettingList() ? this.userMFASettingList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserResponse)) {
            return false;
        }
        GetUserResponse other = (GetUserResponse)((Object)obj);
        return Objects.equals(this.username(), other.username()) && this.hasUserAttributes() == other.hasUserAttributes() && Objects.equals(this.userAttributes(), other.userAttributes()) && this.hasMfaOptions() == other.hasMfaOptions() && Objects.equals(this.mfaOptions(), other.mfaOptions()) && Objects.equals(this.preferredMfaSetting(), other.preferredMfaSetting()) && this.hasUserMFASettingList() == other.hasUserMFASettingList() && Objects.equals(this.userMFASettingList(), other.userMFASettingList());
    }

    public String toString() {
        return ToString.builder((String)"GetUserResponse").add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).add("UserAttributes", this.hasUserAttributes() ? this.userAttributes() : null).add("MFAOptions", this.hasMfaOptions() ? this.mfaOptions() : null).add("PreferredMfaSetting", (Object)this.preferredMfaSetting()).add("UserMFASettingList", this.hasUserMFASettingList() ? this.userMFASettingList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UserAttributes": {
                return Optional.ofNullable(clazz.cast(this.userAttributes()));
            }
            case "MFAOptions": {
                return Optional.ofNullable(clazz.cast(this.mfaOptions()));
            }
            case "PreferredMfaSetting": {
                return Optional.ofNullable(clazz.cast(this.preferredMfaSetting()));
            }
            case "UserMFASettingList": {
                return Optional.ofNullable(clazz.cast(this.userMFASettingList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserResponse, T> g) {
        return obj -> g.apply((GetUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String username;
        private List<AttributeType> userAttributes = DefaultSdkAutoConstructList.getInstance();
        private List<MFAOptionType> mfaOptions = DefaultSdkAutoConstructList.getInstance();
        private String preferredMfaSetting;
        private List<String> userMFASettingList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserResponse model) {
            super(model);
            this.username(model.username);
            this.userAttributes(model.userAttributes);
            this.mfaOptions(model.mfaOptions);
            this.preferredMfaSetting(model.preferredMfaSetting);
            this.userMFASettingList(model.userMFASettingList);
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final Collection<AttributeType.Builder> getUserAttributes() {
            if (this.userAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userAttributes != null ? (Collection)this.userAttributes.stream().map(AttributeType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userAttributes(Collection<AttributeType> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copy(userAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(AttributeType ... userAttributes) {
            this.userAttributes(Arrays.asList(userAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userAttributes(Consumer<AttributeType.Builder> ... userAttributes) {
            this.userAttributes(Stream.of(userAttributes).map(c -> (AttributeType)((AttributeType.Builder)AttributeType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserAttributes(Collection<AttributeType.BuilderImpl> userAttributes) {
            this.userAttributes = AttributeListTypeCopier.copyFromBuilder(userAttributes);
        }

        public final Collection<MFAOptionType.Builder> getMfaOptions() {
            if (this.mfaOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mfaOptions != null ? (Collection)this.mfaOptions.stream().map(MFAOptionType::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mfaOptions(Collection<MFAOptionType> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copy(mfaOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(MFAOptionType ... mfaOptions) {
            this.mfaOptions(Arrays.asList(mfaOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mfaOptions(Consumer<MFAOptionType.Builder> ... mfaOptions) {
            this.mfaOptions(Stream.of(mfaOptions).map(c -> (MFAOptionType)((MFAOptionType.Builder)MFAOptionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMfaOptions(Collection<MFAOptionType.BuilderImpl> mfaOptions) {
            this.mfaOptions = MFAOptionListTypeCopier.copyFromBuilder(mfaOptions);
        }

        public final String getPreferredMfaSetting() {
            return this.preferredMfaSetting;
        }

        @Override
        public final Builder preferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
            return this;
        }

        public final void setPreferredMfaSetting(String preferredMfaSetting) {
            this.preferredMfaSetting = preferredMfaSetting;
        }

        public final Collection<String> getUserMFASettingList() {
            if (this.userMFASettingList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userMFASettingList;
        }

        @Override
        public final Builder userMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userMFASettingList(String ... userMFASettingList) {
            this.userMFASettingList(Arrays.asList(userMFASettingList));
            return this;
        }

        public final void setUserMFASettingList(Collection<String> userMFASettingList) {
            this.userMFASettingList = UserMFASettingListTypeCopier.copy(userMFASettingList);
        }

        @Override
        public GetUserResponse build() {
            return new GetUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUserResponse> {
        public Builder username(String var1);

        public Builder userAttributes(Collection<AttributeType> var1);

        public Builder userAttributes(AttributeType ... var1);

        public Builder userAttributes(Consumer<AttributeType.Builder> ... var1);

        public Builder mfaOptions(Collection<MFAOptionType> var1);

        public Builder mfaOptions(MFAOptionType ... var1);

        public Builder mfaOptions(Consumer<MFAOptionType.Builder> ... var1);

        public Builder preferredMfaSetting(String var1);

        public Builder userMFASettingList(Collection<String> var1);

        public Builder userMFASettingList(String ... var1);
    }
}

