/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AnalyticsMetadataType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthFlowType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthParametersTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ClientMetadataTypeCopier;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ContextDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminInitiateAuthRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminInitiateAuthRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(AdminInitiateAuthRequest.getter(AdminInitiateAuthRequest::userPoolId)).setter(AdminInitiateAuthRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(AdminInitiateAuthRequest.getter(AdminInitiateAuthRequest::clientId)).setter(AdminInitiateAuthRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> AUTH_FLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthFlow").getter(AdminInitiateAuthRequest.getter(AdminInitiateAuthRequest::authFlowAsString)).setter(AdminInitiateAuthRequest.setter(Builder::authFlow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthFlow").build()}).build();
    private static final SdkField<Map<String, String>> AUTH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AuthParameters").getter(AdminInitiateAuthRequest.getter(AdminInitiateAuthRequest::authParameters)).setter(AdminInitiateAuthRequest.setter(Builder::authParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientMetadata").getter(AdminInitiateAuthRequest.getter(AdminInitiateAuthRequest::clientMetadata)).setter(AdminInitiateAuthRequest.setter(Builder::clientMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AnalyticsMetadataType> ANALYTICS_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnalyticsMetadata").getter(AdminInitiateAuthRequest.getter(AdminInitiateAuthRequest::analyticsMetadata)).setter(AdminInitiateAuthRequest.setter(Builder::analyticsMetadata)).constructor(AnalyticsMetadataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyticsMetadata").build()}).build();
    private static final SdkField<ContextDataType> CONTEXT_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContextData").getter(AdminInitiateAuthRequest.getter(AdminInitiateAuthRequest::contextData)).setter(AdminInitiateAuthRequest.setter(Builder::contextData)).constructor(ContextDataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CLIENT_ID_FIELD, AUTH_FLOW_FIELD, AUTH_PARAMETERS_FIELD, CLIENT_METADATA_FIELD, ANALYTICS_METADATA_FIELD, CONTEXT_DATA_FIELD));
    private final String userPoolId;
    private final String clientId;
    private final String authFlow;
    private final Map<String, String> authParameters;
    private final Map<String, String> clientMetadata;
    private final AnalyticsMetadataType analyticsMetadata;
    private final ContextDataType contextData;

    private AdminInitiateAuthRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.clientId = builder.clientId;
        this.authFlow = builder.authFlow;
        this.authParameters = builder.authParameters;
        this.clientMetadata = builder.clientMetadata;
        this.analyticsMetadata = builder.analyticsMetadata;
        this.contextData = builder.contextData;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public String clientId() {
        return this.clientId;
    }

    public AuthFlowType authFlow() {
        return AuthFlowType.fromValue(this.authFlow);
    }

    public String authFlowAsString() {
        return this.authFlow;
    }

    public boolean hasAuthParameters() {
        return this.authParameters != null && !(this.authParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> authParameters() {
        return this.authParameters;
    }

    public boolean hasClientMetadata() {
        return this.clientMetadata != null && !(this.clientMetadata instanceof SdkAutoConstructMap);
    }

    public Map<String, String> clientMetadata() {
        return this.clientMetadata;
    }

    public AnalyticsMetadataType analyticsMetadata() {
        return this.analyticsMetadata;
    }

    public ContextDataType contextData() {
        return this.contextData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authFlowAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyticsMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminInitiateAuthRequest)) {
            return false;
        }
        AdminInitiateAuthRequest other = (AdminInitiateAuthRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.authFlowAsString(), other.authFlowAsString()) && Objects.equals(this.authParameters(), other.authParameters()) && Objects.equals(this.clientMetadata(), other.clientMetadata()) && Objects.equals(this.analyticsMetadata(), other.analyticsMetadata()) && Objects.equals(this.contextData(), other.contextData());
    }

    public String toString() {
        return ToString.builder((String)"AdminInitiateAuthRequest").add("UserPoolId", (Object)this.userPoolId()).add("ClientId", (Object)(this.clientId() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthFlow", (Object)this.authFlowAsString()).add("AuthParameters", (Object)(this.authParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientMetadata", this.clientMetadata()).add("AnalyticsMetadata", (Object)this.analyticsMetadata()).add("ContextData", (Object)this.contextData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "AuthFlow": {
                return Optional.ofNullable(clazz.cast(this.authFlowAsString()));
            }
            case "AuthParameters": {
                return Optional.ofNullable(clazz.cast(this.authParameters()));
            }
            case "ClientMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientMetadata()));
            }
            case "AnalyticsMetadata": {
                return Optional.ofNullable(clazz.cast(this.analyticsMetadata()));
            }
            case "ContextData": {
                return Optional.ofNullable(clazz.cast(this.contextData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminInitiateAuthRequest, T> g) {
        return obj -> g.apply((AdminInitiateAuthRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private String clientId;
        private String authFlow;
        private Map<String, String> authParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> clientMetadata = DefaultSdkAutoConstructMap.getInstance();
        private AnalyticsMetadataType analyticsMetadata;
        private ContextDataType contextData;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminInitiateAuthRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.clientId(model.clientId);
            this.authFlow(model.authFlow);
            this.authParameters(model.authParameters);
            this.clientMetadata(model.clientMetadata);
            this.analyticsMetadata(model.analyticsMetadata);
            this.contextData(model.contextData);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getAuthFlow() {
            return this.authFlow;
        }

        @Override
        public final Builder authFlow(String authFlow) {
            this.authFlow = authFlow;
            return this;
        }

        @Override
        public final Builder authFlow(AuthFlowType authFlow) {
            this.authFlow(authFlow == null ? null : authFlow.toString());
            return this;
        }

        public final void setAuthFlow(String authFlow) {
            this.authFlow = authFlow;
        }

        public final Map<String, String> getAuthParameters() {
            return this.authParameters;
        }

        @Override
        public final Builder authParameters(Map<String, String> authParameters) {
            this.authParameters = AuthParametersTypeCopier.copy(authParameters);
            return this;
        }

        public final void setAuthParameters(Map<String, String> authParameters) {
            this.authParameters = AuthParametersTypeCopier.copy(authParameters);
        }

        public final Map<String, String> getClientMetadata() {
            return this.clientMetadata;
        }

        @Override
        public final Builder clientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
            return this;
        }

        public final void setClientMetadata(Map<String, String> clientMetadata) {
            this.clientMetadata = ClientMetadataTypeCopier.copy(clientMetadata);
        }

        public final AnalyticsMetadataType.Builder getAnalyticsMetadata() {
            return this.analyticsMetadata != null ? this.analyticsMetadata.toBuilder() : null;
        }

        @Override
        public final Builder analyticsMetadata(AnalyticsMetadataType analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata;
            return this;
        }

        public final void setAnalyticsMetadata(AnalyticsMetadataType.BuilderImpl analyticsMetadata) {
            this.analyticsMetadata = analyticsMetadata != null ? analyticsMetadata.build() : null;
        }

        public final ContextDataType.Builder getContextData() {
            return this.contextData != null ? this.contextData.toBuilder() : null;
        }

        @Override
        public final Builder contextData(ContextDataType contextData) {
            this.contextData = contextData;
            return this;
        }

        public final void setContextData(ContextDataType.BuilderImpl contextData) {
            this.contextData = contextData != null ? contextData.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminInitiateAuthRequest build() {
            return new AdminInitiateAuthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminInitiateAuthRequest> {
        public Builder userPoolId(String var1);

        public Builder clientId(String var1);

        public Builder authFlow(String var1);

        public Builder authFlow(AuthFlowType var1);

        public Builder authParameters(Map<String, String> var1);

        public Builder clientMetadata(Map<String, String> var1);

        public Builder analyticsMetadata(AnalyticsMetadataType var1);

        default public Builder analyticsMetadata(Consumer<AnalyticsMetadataType.Builder> analyticsMetadata) {
            return this.analyticsMetadata((AnalyticsMetadataType)((AnalyticsMetadataType.Builder)AnalyticsMetadataType.builder().applyMutation(analyticsMetadata)).build());
        }

        public Builder contextData(ContextDataType var1);

        default public Builder contextData(Consumer<ContextDataType.Builder> contextData) {
            return this.contextData((ContextDataType)((ContextDataType.Builder)ContextDataType.builder().applyMutation(contextData)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

