/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.EmailSendingAccountType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EmailConfigurationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EmailConfigurationType> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailConfigurationType.getter(EmailConfigurationType::sourceArn)).setter(EmailConfigurationType.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> REPLY_TO_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailConfigurationType.getter(EmailConfigurationType::replyToEmailAddress)).setter(EmailConfigurationType.setter(Builder::replyToEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplyToEmailAddress").build()}).build();
    private static final SdkField<String> EMAIL_SENDING_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailConfigurationType.getter(EmailConfigurationType::emailSendingAccountAsString)).setter(EmailConfigurationType.setter(Builder::emailSendingAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailSendingAccount").build()}).build();
    private static final SdkField<String> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailConfigurationType.getter(EmailConfigurationType::from)).setter(EmailConfigurationType.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()}).build();
    private static final SdkField<String> CONFIGURATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EmailConfigurationType.getter(EmailConfigurationType::configurationSet)).setter(EmailConfigurationType.setter(Builder::configurationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, REPLY_TO_EMAIL_ADDRESS_FIELD, EMAIL_SENDING_ACCOUNT_FIELD, FROM_FIELD, CONFIGURATION_SET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceArn;
    private final String replyToEmailAddress;
    private final String emailSendingAccount;
    private final String from;
    private final String configurationSet;

    private EmailConfigurationType(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.replyToEmailAddress = builder.replyToEmailAddress;
        this.emailSendingAccount = builder.emailSendingAccount;
        this.from = builder.from;
        this.configurationSet = builder.configurationSet;
    }

    public String sourceArn() {
        return this.sourceArn;
    }

    public String replyToEmailAddress() {
        return this.replyToEmailAddress;
    }

    public EmailSendingAccountType emailSendingAccount() {
        return EmailSendingAccountType.fromValue(this.emailSendingAccount);
    }

    public String emailSendingAccountAsString() {
        return this.emailSendingAccount;
    }

    public String from() {
        return this.from;
    }

    public String configurationSet() {
        return this.configurationSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replyToEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSendingAccountAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailConfigurationType)) {
            return false;
        }
        EmailConfigurationType other = (EmailConfigurationType)obj;
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.replyToEmailAddress(), other.replyToEmailAddress()) && Objects.equals(this.emailSendingAccountAsString(), other.emailSendingAccountAsString()) && Objects.equals(this.from(), other.from()) && Objects.equals(this.configurationSet(), other.configurationSet());
    }

    public String toString() {
        return ToString.builder((String)"EmailConfigurationType").add("SourceArn", (Object)this.sourceArn()).add("ReplyToEmailAddress", (Object)this.replyToEmailAddress()).add("EmailSendingAccount", (Object)this.emailSendingAccountAsString()).add("From", (Object)this.from()).add("ConfigurationSet", (Object)this.configurationSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "ReplyToEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.replyToEmailAddress()));
            }
            case "EmailSendingAccount": {
                return Optional.ofNullable(clazz.cast(this.emailSendingAccountAsString()));
            }
            case "From": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "ConfigurationSet": {
                return Optional.ofNullable(clazz.cast(this.configurationSet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailConfigurationType, T> g) {
        return obj -> g.apply((EmailConfigurationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceArn;
        private String replyToEmailAddress;
        private String emailSendingAccount;
        private String from;
        private String configurationSet;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailConfigurationType model) {
            this.sourceArn(model.sourceArn);
            this.replyToEmailAddress(model.replyToEmailAddress);
            this.emailSendingAccount(model.emailSendingAccount);
            this.from(model.from);
            this.configurationSet(model.configurationSet);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final String getReplyToEmailAddress() {
            return this.replyToEmailAddress;
        }

        @Override
        public final Builder replyToEmailAddress(String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
            return this;
        }

        public final void setReplyToEmailAddress(String replyToEmailAddress) {
            this.replyToEmailAddress = replyToEmailAddress;
        }

        public final String getEmailSendingAccount() {
            return this.emailSendingAccount;
        }

        @Override
        public final Builder emailSendingAccount(String emailSendingAccount) {
            this.emailSendingAccount = emailSendingAccount;
            return this;
        }

        @Override
        public final Builder emailSendingAccount(EmailSendingAccountType emailSendingAccount) {
            this.emailSendingAccount(emailSendingAccount == null ? null : emailSendingAccount.toString());
            return this;
        }

        public final void setEmailSendingAccount(String emailSendingAccount) {
            this.emailSendingAccount = emailSendingAccount;
        }

        public final String getFrom() {
            return this.from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        public final String getConfigurationSet() {
            return this.configurationSet;
        }

        @Override
        public final Builder configurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final void setConfigurationSet(String configurationSet) {
            this.configurationSet = configurationSet;
        }

        public EmailConfigurationType build() {
            return new EmailConfigurationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EmailConfigurationType> {
        public Builder sourceArn(String var1);

        public Builder replyToEmailAddress(String var1);

        public Builder emailSendingAccount(String var1);

        public Builder emailSendingAccount(EmailSendingAccountType var1);

        public Builder from(String var1);

        public Builder configurationSet(String var1);
    }
}

