/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpHeader
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpHeader> {
    private static final SdkField<String> HEADER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HttpHeader.getter(HttpHeader::headerName)).setter(HttpHeader.setter(Builder::headerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headerName").build()}).build();
    private static final SdkField<String> HEADER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HttpHeader.getter(HttpHeader::headerValue)).setter(HttpHeader.setter(Builder::headerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headerValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_NAME_FIELD, HEADER_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String headerName;
    private final String headerValue;

    private HttpHeader(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.headerValue = builder.headerValue;
    }

    public String headerName() {
        return this.headerName;
    }

    public String headerValue() {
        return this.headerValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.headerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.headerValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpHeader)) {
            return false;
        }
        HttpHeader other = (HttpHeader)obj;
        return Objects.equals(this.headerName(), other.headerName()) && Objects.equals(this.headerValue(), other.headerValue());
    }

    public String toString() {
        return ToString.builder((String)"HttpHeader").add("HeaderName", (Object)this.headerName()).add("HeaderValue", (Object)this.headerValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headerName": {
                return Optional.ofNullable(clazz.cast(this.headerName()));
            }
            case "headerValue": {
                return Optional.ofNullable(clazz.cast(this.headerValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpHeader, T> g) {
        return obj -> g.apply((HttpHeader)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String headerName;
        private String headerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpHeader model) {
            this.headerName(model.headerName);
            this.headerValue(model.headerValue);
        }

        public final String getHeaderName() {
            return this.headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        public final String getHeaderValue() {
            return this.headerValue;
        }

        @Override
        public final Builder headerValue(String headerValue) {
            this.headerValue = headerValue;
            return this;
        }

        public final void setHeaderValue(String headerValue) {
            this.headerValue = headerValue;
        }

        public HttpHeader build() {
            return new HttpHeader(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpHeader> {
        public Builder headerName(String var1);

        public Builder headerValue(String var1);
    }
}

