/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListOfStringTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCsvHeaderResponse
extends CognitoIdentityProviderResponse
implements ToCopyableBuilder<Builder, GetCsvHeaderResponse> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCsvHeaderResponse.getter(GetCsvHeaderResponse::userPoolId)).setter(GetCsvHeaderResponse.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<List<String>> CSV_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetCsvHeaderResponse.getter(GetCsvHeaderResponse::csvHeader)).setter(GetCsvHeaderResponse.setter(Builder::csvHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CSVHeader").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, CSV_HEADER_FIELD));
    private final String userPoolId;
    private final List<String> csvHeader;

    private GetCsvHeaderResponse(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.csvHeader = builder.csvHeader;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    public boolean hasCsvHeader() {
        return this.csvHeader != null && !(this.csvHeader instanceof SdkAutoConstructList);
    }

    public List<String> csvHeader() {
        return this.csvHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvHeader());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCsvHeaderResponse)) {
            return false;
        }
        GetCsvHeaderResponse other = (GetCsvHeaderResponse)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.csvHeader(), other.csvHeader());
    }

    public String toString() {
        return ToString.builder((String)"GetCsvHeaderResponse").add("UserPoolId", (Object)this.userPoolId()).add("CSVHeader", this.csvHeader()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "CSVHeader": {
                return Optional.ofNullable(clazz.cast(this.csvHeader()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCsvHeaderResponse, T> g) {
        return obj -> g.apply((GetCsvHeaderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderResponse.BuilderImpl
    implements Builder {
        private String userPoolId;
        private List<String> csvHeader = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCsvHeaderResponse model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.csvHeader(model.csvHeader);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        public final Collection<String> getCsvHeader() {
            return this.csvHeader;
        }

        @Override
        public final Builder csvHeader(Collection<String> csvHeader) {
            this.csvHeader = ListOfStringTypesCopier.copy(csvHeader);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder csvHeader(String ... csvHeader) {
            this.csvHeader(Arrays.asList(csvHeader));
            return this;
        }

        public final void setCsvHeader(Collection<String> csvHeader) {
            this.csvHeader = ListOfStringTypesCopier.copy(csvHeader);
        }

        @Override
        public GetCsvHeaderResponse build() {
            return new GetCsvHeaderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCsvHeaderResponse> {
        public Builder userPoolId(String var1);

        public Builder csvHeader(Collection<String> var1);

        public Builder csvHeader(String ... var1);
    }
}

