/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderClient;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AdminListUserAuthEventsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.AuthEventType;

public class AdminListUserAuthEventsIterable
implements SdkIterable<AdminListUserAuthEventsResponse> {
    private final CognitoIdentityProviderClient client;
    private final AdminListUserAuthEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public AdminListUserAuthEventsIterable(CognitoIdentityProviderClient client, AdminListUserAuthEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new AdminListUserAuthEventsResponseFetcher();
    }

    public Iterator<AdminListUserAuthEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AuthEventType> authEvents() {
        Function<AdminListUserAuthEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.authEvents() != null) {
                return response.authEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class AdminListUserAuthEventsResponseFetcher
    implements SyncPageFetcher<AdminListUserAuthEventsResponse> {
        private AdminListUserAuthEventsResponseFetcher() {
        }

        public boolean hasNextPage(AdminListUserAuthEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public AdminListUserAuthEventsResponse nextPage(AdminListUserAuthEventsResponse previousPage) {
            if (previousPage == null) {
                return AdminListUserAuthEventsIterable.this.client.adminListUserAuthEvents(AdminListUserAuthEventsIterable.this.firstRequest);
            }
            return AdminListUserAuthEventsIterable.this.client.adminListUserAuthEvents((AdminListUserAuthEventsRequest)((Object)AdminListUserAuthEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

