/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.LambdaConfigType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserPoolDescriptionType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserPoolDescriptionType> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserPoolDescriptionType.getter(UserPoolDescriptionType::id)).setter(UserPoolDescriptionType.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserPoolDescriptionType.getter(UserPoolDescriptionType::name)).setter(UserPoolDescriptionType.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<LambdaConfigType> LAMBDA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UserPoolDescriptionType.getter(UserPoolDescriptionType::lambdaConfig)).setter(UserPoolDescriptionType.setter(Builder::lambdaConfig)).constructor(LambdaConfigType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UserPoolDescriptionType.getter(UserPoolDescriptionType::statusAsString)).setter(UserPoolDescriptionType.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UserPoolDescriptionType.getter(UserPoolDescriptionType::lastModifiedDate)).setter(UserPoolDescriptionType.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UserPoolDescriptionType.getter(UserPoolDescriptionType::creationDate)).setter(UserPoolDescriptionType.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, LAMBDA_CONFIG_FIELD, STATUS_FIELD, LAST_MODIFIED_DATE_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final LambdaConfigType lambdaConfig;
    private final String status;
    private final Instant lastModifiedDate;
    private final Instant creationDate;

    private UserPoolDescriptionType(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.lambdaConfig = builder.lambdaConfig;
        this.status = builder.status;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.creationDate = builder.creationDate;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public LambdaConfigType lambdaConfig() {
        return this.lambdaConfig;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserPoolDescriptionType)) {
            return false;
        }
        UserPoolDescriptionType other = (UserPoolDescriptionType)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.lambdaConfig(), other.lambdaConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"UserPoolDescriptionType").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("LambdaConfig", (Object)this.lambdaConfig()).add("Status", (Object)this.statusAsString()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LambdaConfig": {
                return Optional.ofNullable(clazz.cast(this.lambdaConfig()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserPoolDescriptionType, T> g) {
        return obj -> g.apply((UserPoolDescriptionType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private LambdaConfigType lambdaConfig;
        private String status;
        private Instant lastModifiedDate;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UserPoolDescriptionType model) {
            this.id(model.id);
            this.name(model.name);
            this.lambdaConfig(model.lambdaConfig);
            this.status(model.status);
            this.lastModifiedDate(model.lastModifiedDate);
            this.creationDate(model.creationDate);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final LambdaConfigType.Builder getLambdaConfig() {
            return this.lambdaConfig != null ? this.lambdaConfig.toBuilder() : null;
        }

        @Override
        public final Builder lambdaConfig(LambdaConfigType lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        public final void setLambdaConfig(LambdaConfigType.BuilderImpl lambdaConfig) {
            this.lambdaConfig = lambdaConfig != null ? lambdaConfig.build() : null;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public UserPoolDescriptionType build() {
            return new UserPoolDescriptionType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserPoolDescriptionType> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder lambdaConfig(LambdaConfigType var1);

        default public Builder lambdaConfig(Consumer<LambdaConfigType.Builder> lambdaConfig) {
            return this.lambdaConfig((LambdaConfigType)((LambdaConfigType.Builder)LambdaConfigType.builder().applyMutation(lambdaConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder creationDate(Instant var1);
    }
}

