/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SMSMfaSettingsType;
import software.amazon.awssdk.services.cognitoidentityprovider.model.SoftwareTokenMfaSettingsType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminSetUserMfaPreferenceRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminSetUserMfaPreferenceRequest> {
    private static final SdkField<SMSMfaSettingsType> SMS_MFA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AdminSetUserMfaPreferenceRequest.getter(AdminSetUserMfaPreferenceRequest::smsMfaSettings)).setter(AdminSetUserMfaPreferenceRequest.setter(Builder::smsMfaSettings)).constructor(SMSMfaSettingsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMfaSettings").build()}).build();
    private static final SdkField<SoftwareTokenMfaSettingsType> SOFTWARE_TOKEN_MFA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AdminSetUserMfaPreferenceRequest.getter(AdminSetUserMfaPreferenceRequest::softwareTokenMfaSettings)).setter(AdminSetUserMfaPreferenceRequest.setter(Builder::softwareTokenMfaSettings)).constructor(SoftwareTokenMfaSettingsType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareTokenMfaSettings").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AdminSetUserMfaPreferenceRequest.getter(AdminSetUserMfaPreferenceRequest::username)).setter(AdminSetUserMfaPreferenceRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AdminSetUserMfaPreferenceRequest.getter(AdminSetUserMfaPreferenceRequest::userPoolId)).setter(AdminSetUserMfaPreferenceRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MFA_SETTINGS_FIELD, SOFTWARE_TOKEN_MFA_SETTINGS_FIELD, USERNAME_FIELD, USER_POOL_ID_FIELD));
    private final SMSMfaSettingsType smsMfaSettings;
    private final SoftwareTokenMfaSettingsType softwareTokenMfaSettings;
    private final String username;
    private final String userPoolId;

    private AdminSetUserMfaPreferenceRequest(BuilderImpl builder) {
        super(builder);
        this.smsMfaSettings = builder.smsMfaSettings;
        this.softwareTokenMfaSettings = builder.softwareTokenMfaSettings;
        this.username = builder.username;
        this.userPoolId = builder.userPoolId;
    }

    public SMSMfaSettingsType smsMfaSettings() {
        return this.smsMfaSettings;
    }

    public SoftwareTokenMfaSettingsType softwareTokenMfaSettings() {
        return this.softwareTokenMfaSettings;
    }

    public String username() {
        return this.username;
    }

    public String userPoolId() {
        return this.userPoolId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareTokenMfaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminSetUserMfaPreferenceRequest)) {
            return false;
        }
        AdminSetUserMfaPreferenceRequest other = (AdminSetUserMfaPreferenceRequest)((Object)obj);
        return Objects.equals(this.smsMfaSettings(), other.smsMfaSettings()) && Objects.equals(this.softwareTokenMfaSettings(), other.softwareTokenMfaSettings()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.userPoolId(), other.userPoolId());
    }

    public String toString() {
        return ToString.builder((String)"AdminSetUserMfaPreferenceRequest").add("SMSMfaSettings", (Object)this.smsMfaSettings()).add("SoftwareTokenMfaSettings", (Object)this.softwareTokenMfaSettings()).add("Username", (Object)this.username()).add("UserPoolId", (Object)this.userPoolId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SMSMfaSettings": {
                return Optional.ofNullable(clazz.cast(this.smsMfaSettings()));
            }
            case "SoftwareTokenMfaSettings": {
                return Optional.ofNullable(clazz.cast(this.softwareTokenMfaSettings()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdminSetUserMfaPreferenceRequest, T> g) {
        return obj -> g.apply((AdminSetUserMfaPreferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private SMSMfaSettingsType smsMfaSettings;
        private SoftwareTokenMfaSettingsType softwareTokenMfaSettings;
        private String username;
        private String userPoolId;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminSetUserMfaPreferenceRequest model) {
            super(model);
            this.smsMfaSettings(model.smsMfaSettings);
            this.softwareTokenMfaSettings(model.softwareTokenMfaSettings);
            this.username(model.username);
            this.userPoolId(model.userPoolId);
        }

        public final SMSMfaSettingsType.Builder getSMSMfaSettings() {
            return this.smsMfaSettings != null ? this.smsMfaSettings.toBuilder() : null;
        }

        @Override
        public final Builder smsMfaSettings(SMSMfaSettingsType smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings;
            return this;
        }

        public final void setSMSMfaSettings(SMSMfaSettingsType.BuilderImpl smsMfaSettings) {
            this.smsMfaSettings = smsMfaSettings != null ? smsMfaSettings.build() : null;
        }

        public final SoftwareTokenMfaSettingsType.Builder getSoftwareTokenMfaSettings() {
            return this.softwareTokenMfaSettings != null ? this.softwareTokenMfaSettings.toBuilder() : null;
        }

        @Override
        public final Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings;
            return this;
        }

        public final void setSoftwareTokenMfaSettings(SoftwareTokenMfaSettingsType.BuilderImpl softwareTokenMfaSettings) {
            this.softwareTokenMfaSettings = softwareTokenMfaSettings != null ? softwareTokenMfaSettings.build() : null;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminSetUserMfaPreferenceRequest build() {
            return new AdminSetUserMfaPreferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminSetUserMfaPreferenceRequest> {
        public Builder smsMfaSettings(SMSMfaSettingsType var1);

        default public Builder smsMfaSettings(Consumer<SMSMfaSettingsType.Builder> smsMfaSettings) {
            return this.smsMfaSettings((SMSMfaSettingsType)((SMSMfaSettingsType.Builder)SMSMfaSettingsType.builder().applyMutation(smsMfaSettings)).build());
        }

        public Builder softwareTokenMfaSettings(SoftwareTokenMfaSettingsType var1);

        default public Builder softwareTokenMfaSettings(Consumer<SoftwareTokenMfaSettingsType.Builder> softwareTokenMfaSettings) {
            return this.softwareTokenMfaSettings((SoftwareTokenMfaSettingsType)((SoftwareTokenMfaSettingsType.Builder)SoftwareTokenMfaSettingsType.builder().applyMutation(softwareTokenMfaSettings)).build());
        }

        public Builder username(String var1);

        public Builder userPoolId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

