/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityAsyncClient;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityAsyncClientBuilder;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityServiceClientConfiguration;
import software.amazon.awssdk.services.cognitoidentity.DefaultCognitoIdentityAsyncClient;
import software.amazon.awssdk.services.cognitoidentity.DefaultCognitoIdentityBaseClientBuilder;
import software.amazon.awssdk.services.cognitoidentity.endpoints.CognitoIdentityEndpointProvider;

@SdkInternalApi
final class DefaultCognitoIdentityAsyncClientBuilder
extends DefaultCognitoIdentityBaseClientBuilder<CognitoIdentityAsyncClientBuilder, CognitoIdentityAsyncClient>
implements CognitoIdentityAsyncClientBuilder {
    DefaultCognitoIdentityAsyncClientBuilder() {
    }

    @Override
    public DefaultCognitoIdentityAsyncClientBuilder endpointProvider(CognitoIdentityEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CognitoIdentityAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCognitoIdentityAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CognitoIdentityServiceClientConfiguration serviceClientConfiguration = CognitoIdentityServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCognitoIdentityAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

