/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityException;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.CreateIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DeleteIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.DescribeIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeveloperUserAlreadyRegisteredException;
import software.amazon.awssdk.services.cognitoidentity.model.ExternalServiceException;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetIdentityPoolRolesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenResponse;
import software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetPrincipalTagAttributeMapResponse;
import software.amazon.awssdk.services.cognitoidentity.model.InternalErrorException;
import software.amazon.awssdk.services.cognitoidentity.model.InvalidIdentityPoolConfigurationException;
import software.amazon.awssdk.services.cognitoidentity.model.InvalidParameterException;
import software.amazon.awssdk.services.cognitoidentity.model.LimitExceededException;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentityPoolsResponse;
import software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.MergeDeveloperIdentitiesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.NotAuthorizedException;
import software.amazon.awssdk.services.cognitoidentity.model.ResourceConflictException;
import software.amazon.awssdk.services.cognitoidentity.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import software.amazon.awssdk.services.cognitoidentity.model.SetIdentityPoolRolesResponse;
import software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapRequest;
import software.amazon.awssdk.services.cognitoidentity.model.SetPrincipalTagAttributeMapResponse;
import software.amazon.awssdk.services.cognitoidentity.model.TagResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.TagResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.TooManyRequestsException;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkDeveloperIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UntagResourceRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UntagResourceResponse;
import software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import software.amazon.awssdk.services.cognitoidentity.model.UpdateIdentityPoolResponse;
import software.amazon.awssdk.services.cognitoidentity.paginators.ListIdentityPoolsIterable;
import software.amazon.awssdk.services.cognitoidentity.transform.CreateIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DeleteIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DeleteIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DescribeIdentityPoolRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.DescribeIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetCredentialsForIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetIdRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetIdentityPoolRolesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetOpenIdTokenForDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetOpenIdTokenRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.GetPrincipalTagAttributeMapRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListIdentityPoolsRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.LookupDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.MergeDeveloperIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.SetIdentityPoolRolesRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.SetPrincipalTagAttributeMapRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UnlinkDeveloperIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UnlinkIdentityRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cognitoidentity.transform.UpdateIdentityPoolRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCognitoIdentityClient
implements CognitoIdentityClient {
    private static final Logger log = Logger.loggerFor(DefaultCognitoIdentityClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCognitoIdentityClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "cognito-identity";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateIdentityPoolResponse createIdentityPool(CreateIdentityPoolRequest createIdentityPoolRequest) throws InvalidParameterException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, LimitExceededException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIdentityPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, createIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIdentityPool");
            CreateIdentityPoolResponse createIdentityPoolResponse = (CreateIdentityPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIdentityPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createIdentityPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createIdentityPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$createIdentityPool$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentitiesResponse deleteIdentities(DeleteIdentitiesRequest deleteIdentitiesRequest) throws InvalidParameterException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, deleteIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentities");
            DeleteIdentitiesResponse deleteIdentitiesResponse = (DeleteIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIdentitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$deleteIdentities$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIdentityPoolResponse deleteIdentityPool(DeleteIdentityPoolRequest deleteIdentityPoolRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteIdentityPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, deleteIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIdentityPool");
            DeleteIdentityPoolResponse deleteIdentityPoolResponse = (DeleteIdentityPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIdentityPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIdentityPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteIdentityPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$deleteIdentityPool$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityResponse describeIdentity(DescribeIdentityRequest describeIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, describeIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentity");
            DescribeIdentityResponse describeIdentityResponse = (DescribeIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$describeIdentity$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIdentityPoolResponse describeIdentityPool(DescribeIdentityPoolRequest describeIdentityPoolRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, describeIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIdentityPool");
            DescribeIdentityPoolResponse describeIdentityPoolResponse = (DescribeIdentityPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIdentityPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeIdentityPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$describeIdentityPool$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCredentialsForIdentityResponse getCredentialsForIdentity(GetCredentialsForIdentityRequest getCredentialsForIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InvalidIdentityPoolConfigurationException, InternalErrorException, ExternalServiceException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCredentialsForIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, getCredentialsForIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCredentialsForIdentity");
            GetCredentialsForIdentityResponse getCredentialsForIdentityResponse = (GetCredentialsForIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCredentialsForIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCredentialsForIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCredentialsForIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCredentialsForIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getCredentialsForIdentity$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdResponse getId(GetIdRequest getIdRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, LimitExceededException, ExternalServiceException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, getIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetId");
            GetIdResponse getIdResponse = (GetIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetId").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getId$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIdentityPoolRolesResponse getIdentityPoolRoles(GetIdentityPoolRolesRequest getIdentityPoolRolesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIdentityPoolRolesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, getIdentityPoolRolesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIdentityPoolRoles");
            GetIdentityPoolRolesResponse getIdentityPoolRolesResponse = (GetIdentityPoolRolesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIdentityPoolRoles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getIdentityPoolRolesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIdentityPoolRolesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIdentityPoolRolesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getIdentityPoolRoles$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOpenIdTokenResponse getOpenIdToken(GetOpenIdTokenRequest getOpenIdTokenRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, ExternalServiceException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOpenIdTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, getOpenIdTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOpenIdToken");
            GetOpenIdTokenResponse getOpenIdTokenResponse = (GetOpenIdTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOpenIdToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getOpenIdTokenRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOpenIdTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOpenIdTokenResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getOpenIdToken$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOpenIdTokenForDeveloperIdentityResponse getOpenIdTokenForDeveloperIdentity(GetOpenIdTokenForDeveloperIdentityRequest getOpenIdTokenForDeveloperIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, DeveloperUserAlreadyRegisteredException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOpenIdTokenForDeveloperIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, getOpenIdTokenForDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOpenIdTokenForDeveloperIdentity");
            GetOpenIdTokenForDeveloperIdentityResponse getOpenIdTokenForDeveloperIdentityResponse = (GetOpenIdTokenForDeveloperIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOpenIdTokenForDeveloperIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getOpenIdTokenForDeveloperIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOpenIdTokenForDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOpenIdTokenForDeveloperIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getOpenIdTokenForDeveloperIdentity$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPrincipalTagAttributeMapResponse getPrincipalTagAttributeMap(GetPrincipalTagAttributeMapRequest getPrincipalTagAttributeMapRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPrincipalTagAttributeMapResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, getPrincipalTagAttributeMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPrincipalTagAttributeMap");
            GetPrincipalTagAttributeMapResponse getPrincipalTagAttributeMapResponse = (GetPrincipalTagAttributeMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPrincipalTagAttributeMap").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPrincipalTagAttributeMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPrincipalTagAttributeMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPrincipalTagAttributeMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$getPrincipalTagAttributeMap$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentitiesResponse listIdentities(ListIdentitiesRequest listIdentitiesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, listIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentities");
            ListIdentitiesResponse listIdentitiesResponse = (ListIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$listIdentities$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIdentityPoolsResponse listIdentityPools(ListIdentityPoolsRequest listIdentityPoolsRequest) throws InvalidParameterException, NotAuthorizedException, TooManyRequestsException, ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIdentityPoolsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, listIdentityPoolsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIdentityPools");
            ListIdentityPoolsResponse listIdentityPoolsResponse = (ListIdentityPoolsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIdentityPools").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listIdentityPoolsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListIdentityPoolsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listIdentityPoolsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$listIdentityPools$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListIdentityPoolsIterable listIdentityPoolsPaginator(ListIdentityPoolsRequest listIdentityPoolsRequest) throws InvalidParameterException, NotAuthorizedException, TooManyRequestsException, ResourceNotFoundException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        return new ListIdentityPoolsIterable(this, this.applyPaginatorUserAgent(listIdentityPoolsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$listTagsForResource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupDeveloperIdentityResponse lookupDeveloperIdentity(LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LookupDeveloperIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, lookupDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LookupDeveloperIdentity");
            LookupDeveloperIdentityResponse lookupDeveloperIdentityResponse = (LookupDeveloperIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("LookupDeveloperIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)lookupDeveloperIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new LookupDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return lookupDeveloperIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$lookupDeveloperIdentity$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergeDeveloperIdentitiesResponse mergeDeveloperIdentities(MergeDeveloperIdentitiesRequest mergeDeveloperIdentitiesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MergeDeveloperIdentitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, mergeDeveloperIdentitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MergeDeveloperIdentities");
            MergeDeveloperIdentitiesResponse mergeDeveloperIdentitiesResponse = (MergeDeveloperIdentitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MergeDeveloperIdentities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)mergeDeveloperIdentitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new MergeDeveloperIdentitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return mergeDeveloperIdentitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$mergeDeveloperIdentities$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIdentityPoolRolesResponse setIdentityPoolRoles(SetIdentityPoolRolesRequest setIdentityPoolRolesRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, ConcurrentModificationException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetIdentityPoolRolesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, setIdentityPoolRolesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIdentityPoolRoles");
            SetIdentityPoolRolesResponse setIdentityPoolRolesResponse = (SetIdentityPoolRolesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIdentityPoolRoles").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIdentityPoolRolesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIdentityPoolRolesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setIdentityPoolRolesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$setIdentityPoolRoles$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetPrincipalTagAttributeMapResponse setPrincipalTagAttributeMap(SetPrincipalTagAttributeMapRequest setPrincipalTagAttributeMapRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SetPrincipalTagAttributeMapResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, setPrincipalTagAttributeMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetPrincipalTagAttributeMap");
            SetPrincipalTagAttributeMapResponse setPrincipalTagAttributeMapResponse = (SetPrincipalTagAttributeMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetPrincipalTagAttributeMap").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setPrincipalTagAttributeMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetPrincipalTagAttributeMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return setPrincipalTagAttributeMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$setPrincipalTagAttributeMap$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$tagResource$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnlinkDeveloperIdentityResponse unlinkDeveloperIdentity(UnlinkDeveloperIdentityRequest unlinkDeveloperIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnlinkDeveloperIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, unlinkDeveloperIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnlinkDeveloperIdentity");
            UnlinkDeveloperIdentityResponse unlinkDeveloperIdentityResponse = (UnlinkDeveloperIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnlinkDeveloperIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unlinkDeveloperIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnlinkDeveloperIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unlinkDeveloperIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$unlinkDeveloperIdentity$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnlinkIdentityResponse unlinkIdentity(UnlinkIdentityRequest unlinkIdentityRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, ExternalServiceException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnlinkIdentityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, unlinkIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnlinkIdentity");
            UnlinkIdentityResponse unlinkIdentityResponse = (UnlinkIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnlinkIdentity").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unlinkIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnlinkIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unlinkIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$unlinkIdentity$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, TooManyRequestsException, InternalErrorException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$untagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateIdentityPoolResponse updateIdentityPool(UpdateIdentityPoolRequest updateIdentityPoolRequest) throws InvalidParameterException, ResourceNotFoundException, NotAuthorizedException, ResourceConflictException, TooManyRequestsException, InternalErrorException, ConcurrentModificationException, LimitExceededException, AwsServiceException, SdkClientException, CognitoIdentityException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIdentityPoolResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCognitoIdentityClient.resolveMetricPublishers(this.clientConfiguration, updateIdentityPoolRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cognito Identity");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateIdentityPool");
            UpdateIdentityPoolResponse updateIdentityPoolResponse = (UpdateIdentityPoolResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIdentityPool").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIdentityPoolRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateIdentityPoolRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateIdentityPoolResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCognitoIdentityClient.lambda$updateIdentityPool$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CognitoIdentityException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterException").exceptionBuilderSupplier(InvalidParameterException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DeveloperUserAlreadyRegisteredException").exceptionBuilderSupplier(DeveloperUserAlreadyRegisteredException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceConflictException").exceptionBuilderSupplier(ResourceConflictException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExternalServiceException").exceptionBuilderSupplier(ExternalServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotAuthorizedException").exceptionBuilderSupplier(NotAuthorizedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidIdentityPoolConfigurationException").exceptionBuilderSupplier(InvalidIdentityPoolConfigurationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalErrorException").exceptionBuilderSupplier(InternalErrorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CognitoIdentityRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.46").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CognitoIdentityRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateIdentityPool$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unlinkIdentity$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unlinkDeveloperIdentity$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setPrincipalTagAttributeMap$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIdentityPoolRoles$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$mergeDeveloperIdentities$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$lookupDeveloperIdentity$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentityPools$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIdentities$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPrincipalTagAttributeMap$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOpenIdTokenForDeveloperIdentity$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOpenIdToken$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIdentityPoolRoles$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getId$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCredentialsForIdentity$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentityPool$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIdentity$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentityPool$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIdentities$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIdentityPool$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

