/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.UnlinkIdentityRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UnlinkIdentityRequestModelMarshaller {
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").isBinary(false).build();
    private static final MarshallingInfo<Map> LOGINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logins").isBinary(false).build();
    private static final MarshallingInfo<List> LOGINSTOREMOVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoginsToRemove").isBinary(false).build();
    private static final UnlinkIdentityRequestModelMarshaller INSTANCE = new UnlinkIdentityRequestModelMarshaller();

    private UnlinkIdentityRequestModelMarshaller() {
    }

    public static UnlinkIdentityRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnlinkIdentityRequest unlinkIdentityRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)unlinkIdentityRequest), (String)"unlinkIdentityRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)unlinkIdentityRequest.identityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall(unlinkIdentityRequest.logins(), LOGINS_BINDING);
            protocolMarshaller.marshall(unlinkIdentityRequest.loginsToRemove(), LOGINSTOREMOVE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

