/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.IdentitiesListCopier;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListIdentitiesResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, ListIdentitiesResponse> {
    private final String identityPoolId;
    private final List<IdentityDescription> identities;
    private final String nextToken;

    private ListIdentitiesResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identities = builder.identities;
        this.nextToken = builder.nextToken;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public List<IdentityDescription> identities() {
        return this.identities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentitiesResponse)) {
            return false;
        }
        ListIdentitiesResponse other = (ListIdentitiesResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identities(), other.identities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIdentitiesResponse").add("IdentityPoolId", (Object)this.identityPoolId()).add("Identities", this.identities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.of(clazz.cast(this.identityPoolId()));
            }
            case "Identities": {
                return Optional.of(clazz.cast(this.identities()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private List<IdentityDescription> identities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentitiesResponse model) {
            this.identityPoolId(model.identityPoolId);
            this.identities(model.identities);
            this.nextToken(model.nextToken);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final Collection<IdentityDescription.Builder> getIdentities() {
            return this.identities != null ? (Collection)this.identities.stream().map(IdentityDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identities(Collection<IdentityDescription> identities) {
            this.identities = IdentitiesListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(IdentityDescription ... identities) {
            this.identities(Arrays.asList(identities));
            return this;
        }

        public final void setIdentities(Collection<IdentityDescription.BuilderImpl> identities) {
            this.identities = IdentitiesListCopier.copyFromBuilder(identities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIdentitiesResponse build() {
            return new ListIdentitiesResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    CopyableBuilder<Builder, ListIdentitiesResponse> {
        public Builder identityPoolId(String var1);

        public Builder identities(Collection<IdentityDescription> var1);

        public Builder identities(IdentityDescription ... var1);

        public Builder nextToken(String var1);
    }
}

