/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId;

@SdkInternalApi
public class UnprocessedIdentityIdMarshaller {
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").build();
    private static final UnprocessedIdentityIdMarshaller INSTANCE = new UnprocessedIdentityIdMarshaller();

    public static UnprocessedIdentityIdMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnprocessedIdentityId unprocessedIdentityId, ProtocolMarshaller protocolMarshaller) {
        if (unprocessedIdentityId == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)unprocessedIdentityId.identityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall((Object)unprocessedIdentityId.errorCodeString(), ERRORCODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

