/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.CredentialsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Credentials
implements StructuredPojo,
ToCopyableBuilder<Builder, Credentials> {
    private final String accessKeyId;
    private final String secretKey;
    private final String sessionToken;
    private final Instant expiration;

    private Credentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretKey = builder.secretKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretKey() {
        return this.secretKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)obj;
        return Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.secretKey(), other.secretKey()) && Objects.equals(this.sessionToken(), other.sessionToken()) && Objects.equals(this.expiration(), other.expiration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accessKeyId() != null) {
            sb.append("AccessKeyId: ").append(this.accessKeyId()).append(",");
        }
        if (this.secretKey() != null) {
            sb.append("SecretKey: ").append(this.secretKey()).append(",");
        }
        if (this.sessionToken() != null) {
            sb.append("SessionToken: ").append(this.sessionToken()).append(",");
        }
        if (this.expiration() != null) {
            sb.append("Expiration: ").append(this.expiration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessKeyId": {
                return Optional.of(clazz.cast(this.accessKeyId()));
            }
            case "SecretKey": {
                return Optional.of(clazz.cast(this.secretKey()));
            }
            case "SessionToken": {
                return Optional.of(clazz.cast(this.sessionToken()));
            }
            case "Expiration": {
                return Optional.of(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String secretKey;
        private String sessionToken;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(Credentials model) {
            this.accessKeyId(model.accessKeyId);
            this.secretKey(model.secretKey);
            this.sessionToken(model.sessionToken);
            this.expiration(model.expiration);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getSecretKey() {
            return this.secretKey;
        }

        @Override
        public final Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public final void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        public Credentials build() {
            return new Credentials(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Credentials> {
        public Builder accessKeyId(String var1);

        public Builder secretKey(String var1);

        public Builder sessionToken(String var1);

        public Builder expiration(Instant var1);
    }
}

