/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.CognitoIdentityProviderMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CognitoIdentityProvider
implements StructuredPojo,
ToCopyableBuilder<Builder, CognitoIdentityProvider> {
    private final String providerName;
    private final String clientId;
    private final Boolean serverSideTokenCheck;

    private CognitoIdentityProvider(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.clientId = builder.clientId;
        this.serverSideTokenCheck = builder.serverSideTokenCheck;
    }

    public String providerName() {
        return this.providerName;
    }

    public String clientId() {
        return this.clientId;
    }

    public Boolean serverSideTokenCheck() {
        return this.serverSideTokenCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideTokenCheck());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoIdentityProvider)) {
            return false;
        }
        CognitoIdentityProvider other = (CognitoIdentityProvider)obj;
        return Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.serverSideTokenCheck(), other.serverSideTokenCheck());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.clientId() != null) {
            sb.append("ClientId: ").append(this.clientId()).append(",");
        }
        if (this.serverSideTokenCheck() != null) {
            sb.append("ServerSideTokenCheck: ").append(this.serverSideTokenCheck()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderName": {
                return Optional.of(clazz.cast(this.providerName()));
            }
            case "ClientId": {
                return Optional.of(clazz.cast(this.clientId()));
            }
            case "ServerSideTokenCheck": {
                return Optional.of(clazz.cast(this.serverSideTokenCheck()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoIdentityProviderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerName;
        private String clientId;
        private Boolean serverSideTokenCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoIdentityProvider model) {
            this.providerName(model.providerName);
            this.clientId(model.clientId);
            this.serverSideTokenCheck(model.serverSideTokenCheck);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final Boolean getServerSideTokenCheck() {
            return this.serverSideTokenCheck;
        }

        @Override
        public final Builder serverSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
            return this;
        }

        public final void setServerSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
        }

        public CognitoIdentityProvider build() {
            return new CognitoIdentityProvider(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CognitoIdentityProvider> {
        public Builder providerName(String var1);

        public Builder clientId(String var1);

        public Builder serverSideTokenCheck(Boolean var1);
    }
}

