/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.model.ErrorCode;
import software.amazon.awssdk.services.cognitoidentity.transform.UnprocessedIdentityIdMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnprocessedIdentityId
implements StructuredPojo,
ToCopyableBuilder<Builder, UnprocessedIdentityId> {
    private final String identityId;
    private final String errorCode;

    private UnprocessedIdentityId(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.errorCode = builder.errorCode;
    }

    public String identityId() {
        return this.identityId;
    }

    public ErrorCode errorCode() {
        return ErrorCode.fromValue(this.errorCode);
    }

    public String errorCodeString() {
        return this.errorCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.errorCodeString() == null ? 0 : this.errorCodeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnprocessedIdentityId)) {
            return false;
        }
        UnprocessedIdentityId other = (UnprocessedIdentityId)obj;
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.errorCodeString() == null ^ this.errorCodeString() == null) {
            return false;
        }
        return other.errorCodeString() == null || other.errorCodeString().equals(this.errorCodeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.errorCodeString() != null) {
            sb.append("ErrorCode: ").append(this.errorCodeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "ErrorCode": {
                return Optional.of(clazz.cast(this.errorCodeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UnprocessedIdentityIdMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityId;
        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UnprocessedIdentityId model) {
            this.identityId(model.identityId);
            this.errorCode(model.errorCode);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public UnprocessedIdentityId build() {
            return new UnprocessedIdentityId(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnprocessedIdentityId> {
        public Builder identityId(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(ErrorCode var1);
    }
}

