/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityId;
import software.amazon.awssdk.services.cognitoidentity.model.UnprocessedIdentityIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteIdentitiesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DeleteIdentitiesResponse> {
    private final List<UnprocessedIdentityId> unprocessedIdentityIds;

    private DeleteIdentitiesResponse(BuilderImpl builder) {
        this.unprocessedIdentityIds = builder.unprocessedIdentityIds;
    }

    public List<UnprocessedIdentityId> unprocessedIdentityIds() {
        return this.unprocessedIdentityIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.unprocessedIdentityIds() == null ? 0 : this.unprocessedIdentityIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentitiesResponse)) {
            return false;
        }
        DeleteIdentitiesResponse other = (DeleteIdentitiesResponse)((Object)obj);
        if (other.unprocessedIdentityIds() == null ^ this.unprocessedIdentityIds() == null) {
            return false;
        }
        return other.unprocessedIdentityIds() == null || other.unprocessedIdentityIds().equals(this.unprocessedIdentityIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.unprocessedIdentityIds() != null) {
            sb.append("UnprocessedIdentityIds: ").append(this.unprocessedIdentityIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedIdentityIds": {
                return Optional.of(clazz.cast(this.unprocessedIdentityIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<UnprocessedIdentityId> unprocessedIdentityIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentitiesResponse model) {
            this.unprocessedIdentityIds(model.unprocessedIdentityIds);
        }

        public final Collection<UnprocessedIdentityId.Builder> getUnprocessedIdentityIds() {
            return this.unprocessedIdentityIds != null ? (Collection)this.unprocessedIdentityIds.stream().map(UnprocessedIdentityId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copy(unprocessedIdentityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentityIds(UnprocessedIdentityId ... unprocessedIdentityIds) {
            this.unprocessedIdentityIds(Arrays.asList(unprocessedIdentityIds));
            return this;
        }

        public final void setUnprocessedIdentityIds(Collection<UnprocessedIdentityId.BuilderImpl> unprocessedIdentityIds) {
            this.unprocessedIdentityIds = UnprocessedIdentityIdListCopier.copyFromBuilder(unprocessedIdentityIds);
        }

        public DeleteIdentitiesResponse build() {
            return new DeleteIdentitiesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteIdentitiesResponse> {
        public Builder unprocessedIdentityIds(Collection<UnprocessedIdentityId> var1);

        public Builder unprocessedIdentityIds(UnprocessedIdentityId ... var1);
    }
}

