/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRuleMatchType;
import software.amazon.awssdk.services.cognitoidentity.transform.MappingRuleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MappingRule
implements StructuredPojo,
ToCopyableBuilder<Builder, MappingRule> {
    private final String claim;
    private final String matchType;
    private final String value;
    private final String roleARN;

    private MappingRule(BuilderImpl builder) {
        this.claim = builder.claim;
        this.matchType = builder.matchType;
        this.value = builder.value;
        this.roleARN = builder.roleARN;
    }

    public String claim() {
        return this.claim;
    }

    public String matchType() {
        return this.matchType;
    }

    public String value() {
        return this.value;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.claim() == null ? 0 : this.claim().hashCode());
        hashCode = 31 * hashCode + (this.matchType() == null ? 0 : this.matchType().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MappingRule)) {
            return false;
        }
        MappingRule other = (MappingRule)obj;
        if (other.claim() == null ^ this.claim() == null) {
            return false;
        }
        if (other.claim() != null && !other.claim().equals(this.claim())) {
            return false;
        }
        if (other.matchType() == null ^ this.matchType() == null) {
            return false;
        }
        if (other.matchType() != null && !other.matchType().equals(this.matchType())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        return other.roleARN() == null || other.roleARN().equals(this.roleARN());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claim() != null) {
            sb.append("Claim: ").append(this.claim()).append(",");
        }
        if (this.matchType() != null) {
            sb.append("MatchType: ").append(this.matchType()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MappingRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String claim;
        private String matchType;
        private String value;
        private String roleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(MappingRule model) {
            this.setClaim(model.claim);
            this.setMatchType(model.matchType);
            this.setValue(model.value);
            this.setRoleARN(model.roleARN);
        }

        public final String getClaim() {
            return this.claim;
        }

        @Override
        public final Builder claim(String claim) {
            this.claim = claim;
            return this;
        }

        public final void setClaim(String claim) {
            this.claim = claim;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MappingRuleMatchType matchType) {
            this.matchType(matchType.toString());
            return this;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public MappingRule build() {
            return new MappingRule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MappingRule> {
        public Builder claim(String var1);

        public Builder matchType(String var1);

        public Builder matchType(MappingRuleMatchType var1);

        public Builder value(String var1);

        public Builder roleARN(String var1);
    }
}

