/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cognitoidentity.model.DeveloperUserIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LookupDeveloperIdentityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, LookupDeveloperIdentityResponse> {
    private final String identityId;
    private final List<String> developerUserIdentifierList;
    private final String nextToken;

    private LookupDeveloperIdentityResponse(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.developerUserIdentifierList = builder.developerUserIdentifierList;
        this.nextToken = builder.nextToken;
    }

    public String identityId() {
        return this.identityId;
    }

    public List<String> developerUserIdentifierList() {
        return this.developerUserIdentifierList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.developerUserIdentifierList() == null ? 0 : this.developerUserIdentifierList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupDeveloperIdentityResponse)) {
            return false;
        }
        LookupDeveloperIdentityResponse other = (LookupDeveloperIdentityResponse)((Object)obj);
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.developerUserIdentifierList() == null ^ this.developerUserIdentifierList() == null) {
            return false;
        }
        if (other.developerUserIdentifierList() != null && !other.developerUserIdentifierList().equals(this.developerUserIdentifierList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.developerUserIdentifierList() != null) {
            sb.append("DeveloperUserIdentifierList: ").append(this.developerUserIdentifierList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityId;
        private List<String> developerUserIdentifierList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupDeveloperIdentityResponse model) {
            this.setIdentityId(model.identityId);
            this.setDeveloperUserIdentifierList(model.developerUserIdentifierList);
            this.setNextToken(model.nextToken);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getDeveloperUserIdentifierList() {
            return this.developerUserIdentifierList;
        }

        @Override
        public final Builder developerUserIdentifierList(Collection<String> developerUserIdentifierList) {
            this.developerUserIdentifierList = DeveloperUserIdentifierListCopier.copy(developerUserIdentifierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder developerUserIdentifierList(String ... developerUserIdentifierList) {
            this.developerUserIdentifierList(Arrays.asList(developerUserIdentifierList));
            return this;
        }

        public final void setDeveloperUserIdentifierList(Collection<String> developerUserIdentifierList) {
            this.developerUserIdentifierList = DeveloperUserIdentifierListCopier.copy(developerUserIdentifierList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public LookupDeveloperIdentityResponse build() {
            return new LookupDeveloperIdentityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LookupDeveloperIdentityResponse> {
        public Builder identityId(String var1);

        public Builder developerUserIdentifierList(Collection<String> var1);

        public Builder developerUserIdentifierList(String ... var1);

        public Builder nextToken(String var1);
    }
}

