/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.transform.CognitoIdentityProviderMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CognitoIdentityProvider
implements StructuredPojo,
ToCopyableBuilder<Builder, CognitoIdentityProvider> {
    private final String providerName;
    private final String clientId;
    private final Boolean serverSideTokenCheck;

    private CognitoIdentityProvider(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.clientId = builder.clientId;
        this.serverSideTokenCheck = builder.serverSideTokenCheck;
    }

    public String providerName() {
        return this.providerName;
    }

    public String clientId() {
        return this.clientId;
    }

    public Boolean serverSideTokenCheck() {
        return this.serverSideTokenCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.providerName() == null ? 0 : this.providerName().hashCode());
        hashCode = 31 * hashCode + (this.clientId() == null ? 0 : this.clientId().hashCode());
        hashCode = 31 * hashCode + (this.serverSideTokenCheck() == null ? 0 : this.serverSideTokenCheck().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoIdentityProvider)) {
            return false;
        }
        CognitoIdentityProvider other = (CognitoIdentityProvider)obj;
        if (other.providerName() == null ^ this.providerName() == null) {
            return false;
        }
        if (other.providerName() != null && !other.providerName().equals(this.providerName())) {
            return false;
        }
        if (other.clientId() == null ^ this.clientId() == null) {
            return false;
        }
        if (other.clientId() != null && !other.clientId().equals(this.clientId())) {
            return false;
        }
        if (other.serverSideTokenCheck() == null ^ this.serverSideTokenCheck() == null) {
            return false;
        }
        return other.serverSideTokenCheck() == null || other.serverSideTokenCheck().equals(this.serverSideTokenCheck());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.providerName() != null) {
            sb.append("ProviderName: ").append(this.providerName()).append(",");
        }
        if (this.clientId() != null) {
            sb.append("ClientId: ").append(this.clientId()).append(",");
        }
        if (this.serverSideTokenCheck() != null) {
            sb.append("ServerSideTokenCheck: ").append(this.serverSideTokenCheck()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CognitoIdentityProviderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String providerName;
        private String clientId;
        private Boolean serverSideTokenCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoIdentityProvider model) {
            this.setProviderName(model.providerName);
            this.setClientId(model.clientId);
            this.setServerSideTokenCheck(model.serverSideTokenCheck);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final Boolean getServerSideTokenCheck() {
            return this.serverSideTokenCheck;
        }

        @Override
        public final Builder serverSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
            return this;
        }

        public final void setServerSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
        }

        public CognitoIdentityProvider build() {
            return new CognitoIdentityProvider(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CognitoIdentityProvider> {
        public Builder providerName(String var1);

        public Builder clientId(String var1);

        public Builder serverSideTokenCheck(Boolean var1);
    }
}

