/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType;
import software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType;
import software.amazon.awssdk.services.cognitoidentity.transform.RoleMappingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RoleMapping
implements StructuredPojo,
ToCopyableBuilder<Builder, RoleMapping> {
    private final String type;
    private final String ambiguousRoleResolution;
    private final RulesConfigurationType rulesConfiguration;

    private RoleMapping(BuilderImpl builder) {
        this.type = builder.type;
        this.ambiguousRoleResolution = builder.ambiguousRoleResolution;
        this.rulesConfiguration = builder.rulesConfiguration;
    }

    public String type() {
        return this.type;
    }

    public String ambiguousRoleResolution() {
        return this.ambiguousRoleResolution;
    }

    public RulesConfigurationType rulesConfiguration() {
        return this.rulesConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.ambiguousRoleResolution() == null ? 0 : this.ambiguousRoleResolution().hashCode());
        hashCode = 31 * hashCode + (this.rulesConfiguration() == null ? 0 : this.rulesConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleMapping)) {
            return false;
        }
        RoleMapping other = (RoleMapping)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.ambiguousRoleResolution() == null ^ this.ambiguousRoleResolution() == null) {
            return false;
        }
        if (other.ambiguousRoleResolution() != null && !other.ambiguousRoleResolution().equals(this.ambiguousRoleResolution())) {
            return false;
        }
        if (other.rulesConfiguration() == null ^ this.rulesConfiguration() == null) {
            return false;
        }
        return other.rulesConfiguration() == null || other.rulesConfiguration().equals(this.rulesConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.ambiguousRoleResolution() != null) {
            sb.append("AmbiguousRoleResolution: ").append(this.ambiguousRoleResolution()).append(",");
        }
        if (this.rulesConfiguration() != null) {
            sb.append("RulesConfiguration: ").append(this.rulesConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RoleMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String ambiguousRoleResolution;
        private RulesConfigurationType rulesConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleMapping model) {
            this.setType(model.type);
            this.setAmbiguousRoleResolution(model.ambiguousRoleResolution);
            this.setRulesConfiguration(model.rulesConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RoleMappingType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAmbiguousRoleResolution() {
            return this.ambiguousRoleResolution;
        }

        @Override
        public final Builder ambiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
            return this;
        }

        @Override
        public final Builder ambiguousRoleResolution(AmbiguousRoleResolutionType ambiguousRoleResolution) {
            this.ambiguousRoleResolution(ambiguousRoleResolution.toString());
            return this;
        }

        public final void setAmbiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
        }

        public final RulesConfigurationType getRulesConfiguration() {
            return this.rulesConfiguration;
        }

        @Override
        public final Builder rulesConfiguration(RulesConfigurationType rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration;
            return this;
        }

        public final void setRulesConfiguration(RulesConfigurationType rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration;
        }

        public RoleMapping build() {
            return new RoleMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RoleMapping> {
        public Builder type(String var1);

        public Builder type(RoleMappingType var1);

        public Builder ambiguousRoleResolution(String var1);

        public Builder ambiguousRoleResolution(AmbiguousRoleResolutionType var1);

        public Builder rulesConfiguration(RulesConfigurationType var1);
    }
}

