/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cognitoidentity.model.LoginsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeIdentityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeIdentityResponse> {
    private final String identityId;
    private final List<String> logins;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private DescribeIdentityResponse(BuilderImpl builder) {
        this.identityId = builder.identityId;
        this.logins = builder.logins;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String identityId() {
        return this.identityId;
    }

    public List<String> logins() {
        return this.logins;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.identityId() == null ? 0 : this.identityId().hashCode());
        hashCode = 31 * hashCode + (this.logins() == null ? 0 : this.logins().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityResponse)) {
            return false;
        }
        DescribeIdentityResponse other = (DescribeIdentityResponse)((Object)obj);
        if (other.identityId() == null ^ this.identityId() == null) {
            return false;
        }
        if (other.identityId() != null && !other.identityId().equals(this.identityId())) {
            return false;
        }
        if (other.logins() == null ^ this.logins() == null) {
            return false;
        }
        if (other.logins() != null && !other.logins().equals(this.logins())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        return other.lastModifiedDate() == null || other.lastModifiedDate().equals(this.lastModifiedDate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityId() != null) {
            sb.append("IdentityId: ").append(this.identityId()).append(",");
        }
        if (this.logins() != null) {
            sb.append("Logins: ").append(this.logins()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String identityId;
        private List<String> logins;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityResponse model) {
            this.setIdentityId(model.identityId);
            this.setLogins(model.logins);
            this.setCreationDate(model.creationDate);
            this.setLastModifiedDate(model.lastModifiedDate);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getLogins() {
            return this.logins;
        }

        @Override
        public final Builder logins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logins(String ... logins) {
            this.logins(Arrays.asList(logins));
            return this;
        }

        public final void setLogins(Collection<String> logins) {
            this.logins = LoginsListCopier.copy(logins);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public DescribeIdentityResponse build() {
            return new DescribeIdentityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeIdentityResponse> {
        public Builder identityId(String var1);

        public Builder logins(Collection<String> var1);

        public Builder logins(String ... var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

