/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LookupDeveloperIdentityRequestModelMarshaller {
    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").isBinary(false).build();
    private static final MarshallingInfo<String> DEVELOPERUSERIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeveloperUserIdentifier").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final LookupDeveloperIdentityRequestModelMarshaller INSTANCE = new LookupDeveloperIdentityRequestModelMarshaller();

    private LookupDeveloperIdentityRequestModelMarshaller() {
    }

    public static LookupDeveloperIdentityRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LookupDeveloperIdentityRequest lookupDeveloperIdentityRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)lookupDeveloperIdentityRequest), (String)"lookupDeveloperIdentityRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lookupDeveloperIdentityRequest.identityPoolId(), IDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall((Object)lookupDeveloperIdentityRequest.identityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall((Object)lookupDeveloperIdentityRequest.developerUserIdentifier(), DEVELOPERUSERIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)lookupDeveloperIdentityRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)lookupDeveloperIdentityRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

