/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.ListIdentitiesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListIdentitiesRequestModelMarshaller {
    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Boolean> HIDEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HideDisabled").isBinary(false).build();
    private static final ListIdentitiesRequestModelMarshaller INSTANCE = new ListIdentitiesRequestModelMarshaller();

    private ListIdentitiesRequestModelMarshaller() {
    }

    public static ListIdentitiesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListIdentitiesRequest listIdentitiesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listIdentitiesRequest), (String)"listIdentitiesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listIdentitiesRequest.identityPoolId(), IDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall((Object)listIdentitiesRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listIdentitiesRequest.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)listIdentitiesRequest.hideDisabled(), HIDEDISABLED_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

