/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.Credentials;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CredentialsMarshaller {
    private static final MarshallingInfo<String> ACCESSKEYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessKeyId").isBinary(false).build();
    private static final MarshallingInfo<String> SECRETKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretKey").isBinary(false).build();
    private static final MarshallingInfo<String> SESSIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SessionToken").isBinary(false).build();
    private static final MarshallingInfo<Instant> EXPIRATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expiration").isBinary(false).build();
    private static final CredentialsMarshaller INSTANCE = new CredentialsMarshaller();

    private CredentialsMarshaller() {
    }

    public static CredentialsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Credentials credentials, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)credentials, (String)"credentials");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)credentials.accessKeyId(), ACCESSKEYID_BINDING);
            protocolMarshaller.marshall((Object)credentials.secretKey(), SECRETKEY_BINDING);
            protocolMarshaller.marshall((Object)credentials.sessionToken(), SESSIONTOKEN_BINDING);
            protocolMarshaller.marshall((Object)credentials.expiration(), EXPIRATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

