/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProvider;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityProviderListCopier;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityProvidersCopier;
import software.amazon.awssdk.services.cognitoidentity.model.OIDCProviderListCopier;
import software.amazon.awssdk.services.cognitoidentity.model.SAMLProviderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIdentityPoolResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, CreateIdentityPoolResponse> {
    private final String identityPoolId;
    private final String identityPoolName;
    private final Boolean allowUnauthenticatedIdentities;
    private final Map<String, String> supportedLoginProviders;
    private final String developerProviderName;
    private final List<String> openIdConnectProviderARNs;
    private final List<CognitoIdentityProvider> cognitoIdentityProviders;
    private final List<String> samlProviderARNs;

    private CreateIdentityPoolResponse(BuilderImpl builder) {
        super(builder);
        this.identityPoolId = builder.identityPoolId;
        this.identityPoolName = builder.identityPoolName;
        this.allowUnauthenticatedIdentities = builder.allowUnauthenticatedIdentities;
        this.supportedLoginProviders = builder.supportedLoginProviders;
        this.developerProviderName = builder.developerProviderName;
        this.openIdConnectProviderARNs = builder.openIdConnectProviderARNs;
        this.cognitoIdentityProviders = builder.cognitoIdentityProviders;
        this.samlProviderARNs = builder.samlProviderARNs;
    }

    public String identityPoolId() {
        return this.identityPoolId;
    }

    public String identityPoolName() {
        return this.identityPoolName;
    }

    public Boolean allowUnauthenticatedIdentities() {
        return this.allowUnauthenticatedIdentities;
    }

    public Map<String, String> supportedLoginProviders() {
        return this.supportedLoginProviders;
    }

    public String developerProviderName() {
        return this.developerProviderName;
    }

    public List<String> openIdConnectProviderARNs() {
        return this.openIdConnectProviderARNs;
    }

    public List<CognitoIdentityProvider> cognitoIdentityProviders() {
        return this.cognitoIdentityProviders;
    }

    public List<String> samlProviderARNs() {
        return this.samlProviderARNs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityPoolName());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowUnauthenticatedIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedLoginProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.openIdConnectProviderARNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoIdentityProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlProviderARNs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityPoolResponse)) {
            return false;
        }
        CreateIdentityPoolResponse other = (CreateIdentityPoolResponse)((Object)obj);
        return Objects.equals(this.identityPoolId(), other.identityPoolId()) && Objects.equals(this.identityPoolName(), other.identityPoolName()) && Objects.equals(this.allowUnauthenticatedIdentities(), other.allowUnauthenticatedIdentities()) && Objects.equals(this.supportedLoginProviders(), other.supportedLoginProviders()) && Objects.equals(this.developerProviderName(), other.developerProviderName()) && Objects.equals(this.openIdConnectProviderARNs(), other.openIdConnectProviderARNs()) && Objects.equals(this.cognitoIdentityProviders(), other.cognitoIdentityProviders()) && Objects.equals(this.samlProviderARNs(), other.samlProviderARNs());
    }

    public String toString() {
        return ToString.builder((String)"CreateIdentityPoolResponse").add("IdentityPoolId", (Object)this.identityPoolId()).add("IdentityPoolName", (Object)this.identityPoolName()).add("AllowUnauthenticatedIdentities", (Object)this.allowUnauthenticatedIdentities()).add("SupportedLoginProviders", this.supportedLoginProviders()).add("DeveloperProviderName", (Object)this.developerProviderName()).add("OpenIdConnectProviderARNs", this.openIdConnectProviderARNs()).add("CognitoIdentityProviders", this.cognitoIdentityProviders()).add("SamlProviderARNs", this.samlProviderARNs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityPoolId": {
                return Optional.ofNullable(clazz.cast(this.identityPoolId()));
            }
            case "IdentityPoolName": {
                return Optional.ofNullable(clazz.cast(this.identityPoolName()));
            }
            case "AllowUnauthenticatedIdentities": {
                return Optional.ofNullable(clazz.cast(this.allowUnauthenticatedIdentities()));
            }
            case "SupportedLoginProviders": {
                return Optional.ofNullable(clazz.cast(this.supportedLoginProviders()));
            }
            case "DeveloperProviderName": {
                return Optional.ofNullable(clazz.cast(this.developerProviderName()));
            }
            case "OpenIdConnectProviderARNs": {
                return Optional.ofNullable(clazz.cast(this.openIdConnectProviderARNs()));
            }
            case "CognitoIdentityProviders": {
                return Optional.ofNullable(clazz.cast(this.cognitoIdentityProviders()));
            }
            case "SamlProviderARNs": {
                return Optional.ofNullable(clazz.cast(this.samlProviderARNs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityPoolId;
        private String identityPoolName;
        private Boolean allowUnauthenticatedIdentities;
        private Map<String, String> supportedLoginProviders = DefaultSdkAutoConstructMap.getInstance();
        private String developerProviderName;
        private List<String> openIdConnectProviderARNs = DefaultSdkAutoConstructList.getInstance();
        private List<CognitoIdentityProvider> cognitoIdentityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<String> samlProviderARNs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentityPoolResponse model) {
            super(model);
            this.identityPoolId(model.identityPoolId);
            this.identityPoolName(model.identityPoolName);
            this.allowUnauthenticatedIdentities(model.allowUnauthenticatedIdentities);
            this.supportedLoginProviders(model.supportedLoginProviders);
            this.developerProviderName(model.developerProviderName);
            this.openIdConnectProviderARNs(model.openIdConnectProviderARNs);
            this.cognitoIdentityProviders(model.cognitoIdentityProviders);
            this.samlProviderARNs(model.samlProviderARNs);
        }

        public final String getIdentityPoolId() {
            return this.identityPoolId;
        }

        @Override
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        public final String getIdentityPoolName() {
            return this.identityPoolName;
        }

        @Override
        public final Builder identityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
            return this;
        }

        public final void setIdentityPoolName(String identityPoolName) {
            this.identityPoolName = identityPoolName;
        }

        public final Boolean getAllowUnauthenticatedIdentities() {
            return this.allowUnauthenticatedIdentities;
        }

        @Override
        public final Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
            return this;
        }

        public final void setAllowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.allowUnauthenticatedIdentities = allowUnauthenticatedIdentities;
        }

        public final Map<String, String> getSupportedLoginProviders() {
            return this.supportedLoginProviders;
        }

        @Override
        public final Builder supportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
            return this;
        }

        public final void setSupportedLoginProviders(Map<String, String> supportedLoginProviders) {
            this.supportedLoginProviders = IdentityProvidersCopier.copy(supportedLoginProviders);
        }

        public final String getDeveloperProviderName() {
            return this.developerProviderName;
        }

        @Override
        public final Builder developerProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
            return this;
        }

        public final void setDeveloperProviderName(String developerProviderName) {
            this.developerProviderName = developerProviderName;
        }

        public final Collection<String> getOpenIdConnectProviderARNs() {
            return this.openIdConnectProviderARNs;
        }

        @Override
        public final Builder openIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder openIdConnectProviderARNs(String ... openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs(Arrays.asList(openIdConnectProviderARNs));
            return this;
        }

        public final void setOpenIdConnectProviderARNs(Collection<String> openIdConnectProviderARNs) {
            this.openIdConnectProviderARNs = OIDCProviderListCopier.copy(openIdConnectProviderARNs);
        }

        public final Collection<CognitoIdentityProvider.Builder> getCognitoIdentityProviders() {
            return this.cognitoIdentityProviders != null ? (Collection)this.cognitoIdentityProviders.stream().map(CognitoIdentityProvider::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copy(cognitoIdentityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cognitoIdentityProviders(CognitoIdentityProvider ... cognitoIdentityProviders) {
            this.cognitoIdentityProviders(Arrays.asList(cognitoIdentityProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cognitoIdentityProviders(Consumer<CognitoIdentityProvider.Builder> ... cognitoIdentityProviders) {
            this.cognitoIdentityProviders(Stream.of(cognitoIdentityProviders).map(c -> (CognitoIdentityProvider)((CognitoIdentityProvider.Builder)CognitoIdentityProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCognitoIdentityProviders(Collection<CognitoIdentityProvider.BuilderImpl> cognitoIdentityProviders) {
            this.cognitoIdentityProviders = CognitoIdentityProviderListCopier.copyFromBuilder(cognitoIdentityProviders);
        }

        public final Collection<String> getSamlProviderARNs() {
            return this.samlProviderARNs;
        }

        @Override
        public final Builder samlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samlProviderARNs(String ... samlProviderARNs) {
            this.samlProviderARNs(Arrays.asList(samlProviderARNs));
            return this;
        }

        public final void setSamlProviderARNs(Collection<String> samlProviderARNs) {
            this.samlProviderARNs = SAMLProviderListCopier.copy(samlProviderARNs);
        }

        @Override
        public CreateIdentityPoolResponse build() {
            return new CreateIdentityPoolResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    CopyableBuilder<Builder, CreateIdentityPoolResponse> {
        public Builder identityPoolId(String var1);

        public Builder identityPoolName(String var1);

        public Builder allowUnauthenticatedIdentities(Boolean var1);

        public Builder supportedLoginProviders(Map<String, String> var1);

        public Builder developerProviderName(String var1);

        public Builder openIdConnectProviderARNs(Collection<String> var1);

        public Builder openIdConnectProviderARNs(String ... var1);

        public Builder cognitoIdentityProviders(Collection<CognitoIdentityProvider> var1);

        public Builder cognitoIdentityProviders(CognitoIdentityProvider ... var1);

        public Builder cognitoIdentityProviders(Consumer<CognitoIdentityProvider.Builder> ... var1);

        public Builder samlProviderARNs(Collection<String> var1);

        public Builder samlProviderARNs(String ... var1);
    }
}

