/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.GetOpenIdTokenRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetOpenIdTokenRequestModelMarshaller {
    private static final MarshallingInfo<String> IDENTITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityId").isBinary(false).build();
    private static final MarshallingInfo<Map> LOGINS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Logins").isBinary(false).build();
    private static final GetOpenIdTokenRequestModelMarshaller INSTANCE = new GetOpenIdTokenRequestModelMarshaller();

    private GetOpenIdTokenRequestModelMarshaller() {
    }

    public static GetOpenIdTokenRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetOpenIdTokenRequest getOpenIdTokenRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getOpenIdTokenRequest), (String)"getOpenIdTokenRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getOpenIdTokenRequest.identityId(), IDENTITYID_BINDING);
            protocolMarshaller.marshall(getOpenIdTokenRequest.logins(), LOGINS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

