/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRule;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MappingRuleMarshaller {
    private static final MarshallingInfo<String> CLAIM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Claim").isBinary(false).build();
    private static final MarshallingInfo<String> MATCHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MatchType").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();
    private static final MappingRuleMarshaller INSTANCE = new MappingRuleMarshaller();

    private MappingRuleMarshaller() {
    }

    public static MappingRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MappingRule mappingRule, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)mappingRule, (String)"mappingRule");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)mappingRule.claim(), CLAIM_BINDING);
            protocolMarshaller.marshall((Object)mappingRule.matchTypeAsString(), MATCHTYPE_BINDING);
            protocolMarshaller.marshall((Object)mappingRule.value(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)mappingRule.roleARN(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

