/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cognitoidentity.model.IdentityPoolShortDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IdentityPoolShortDescriptionMarshaller {
    private static final MarshallingInfo<String> IDENTITYPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> IDENTITYPOOLNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdentityPoolName").isBinary(false).build();
    private static final IdentityPoolShortDescriptionMarshaller INSTANCE = new IdentityPoolShortDescriptionMarshaller();

    private IdentityPoolShortDescriptionMarshaller() {
    }

    public static IdentityPoolShortDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IdentityPoolShortDescription identityPoolShortDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)identityPoolShortDescription, (String)"identityPoolShortDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)identityPoolShortDescription.identityPoolId(), IDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall((Object)identityPoolShortDescription.identityPoolName(), IDENTITYPOOLNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

