/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRule;
import software.amazon.awssdk.services.cognitoidentity.model.MappingRulesListCopier;
import software.amazon.awssdk.services.cognitoidentity.transform.RulesConfigurationTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RulesConfigurationType
implements StructuredPojo,
ToCopyableBuilder<Builder, RulesConfigurationType> {
    private final List<MappingRule> rules;

    private RulesConfigurationType(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    public List<MappingRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RulesConfigurationType)) {
            return false;
        }
        RulesConfigurationType other = (RulesConfigurationType)obj;
        return Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"RulesConfigurationType").add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RulesConfigurationTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MappingRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(RulesConfigurationType model) {
            this.rules(model.rules);
        }

        public final Collection<MappingRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(MappingRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<MappingRule> rules) {
            this.rules = MappingRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(MappingRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<MappingRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (MappingRule)((MappingRule.Builder)MappingRule.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<MappingRule.BuilderImpl> rules) {
            this.rules = MappingRulesListCopier.copyFromBuilder(rules);
        }

        public RulesConfigurationType build() {
            return new RulesConfigurationType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RulesConfigurationType> {
        public Builder rules(Collection<MappingRule> var1);

        public Builder rules(MappingRule ... var1);

        public Builder rules(Consumer<MappingRule.Builder> ... var1);
    }
}

