/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cognitoidentity.model.CognitoIdentityResponse;
import software.amazon.awssdk.services.cognitoidentity.model.DeveloperUserIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LookupDeveloperIdentityResponse
extends CognitoIdentityResponse
implements ToCopyableBuilder<Builder, LookupDeveloperIdentityResponse> {
    private final String identityId;
    private final List<String> developerUserIdentifierList;
    private final String nextToken;

    private LookupDeveloperIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityId = builder.identityId;
        this.developerUserIdentifierList = builder.developerUserIdentifierList;
        this.nextToken = builder.nextToken;
    }

    public String identityId() {
        return this.identityId;
    }

    public List<String> developerUserIdentifierList() {
        return this.developerUserIdentifierList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.developerUserIdentifierList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupDeveloperIdentityResponse)) {
            return false;
        }
        LookupDeveloperIdentityResponse other = (LookupDeveloperIdentityResponse)((Object)obj);
        return Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.developerUserIdentifierList(), other.developerUserIdentifierList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"LookupDeveloperIdentityResponse").add("IdentityId", (Object)this.identityId()).add("DeveloperUserIdentifierList", this.developerUserIdentifierList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityId": {
                return Optional.of(clazz.cast(this.identityId()));
            }
            case "DeveloperUserIdentifierList": {
                return Optional.of(clazz.cast(this.developerUserIdentifierList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CognitoIdentityResponse.BuilderImpl
    implements Builder {
        private String identityId;
        private List<String> developerUserIdentifierList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupDeveloperIdentityResponse model) {
            super(model);
            this.identityId(model.identityId);
            this.developerUserIdentifierList(model.developerUserIdentifierList);
            this.nextToken(model.nextToken);
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        public final Collection<String> getDeveloperUserIdentifierList() {
            return this.developerUserIdentifierList;
        }

        @Override
        public final Builder developerUserIdentifierList(Collection<String> developerUserIdentifierList) {
            this.developerUserIdentifierList = DeveloperUserIdentifierListCopier.copy(developerUserIdentifierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder developerUserIdentifierList(String ... developerUserIdentifierList) {
            this.developerUserIdentifierList(Arrays.asList(developerUserIdentifierList));
            return this;
        }

        public final void setDeveloperUserIdentifierList(Collection<String> developerUserIdentifierList) {
            this.developerUserIdentifierList = DeveloperUserIdentifierListCopier.copy(developerUserIdentifierList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public LookupDeveloperIdentityResponse build() {
            return new LookupDeveloperIdentityResponse(this);
        }
    }

    public static interface Builder
    extends CognitoIdentityResponse.Builder,
    CopyableBuilder<Builder, LookupDeveloperIdentityResponse> {
        public Builder identityId(String var1);

        public Builder developerUserIdentifierList(Collection<String> var1);

        public Builder developerUserIdentifierList(String ... var1);

        public Builder nextToken(String var1);
    }
}

