/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.StaticSignerProvider;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.config.defaults.AwsClientConfigurationDefaults;
import software.amazon.awssdk.awscore.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.core.runtime.auth.Signer;
import software.amazon.awssdk.core.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityBaseClientBuilder;

@SdkInternalApi
abstract class DefaultCognitoIdentityBaseClientBuilder<B extends CognitoIdentityBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultCognitoIdentityBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "cognito-identity";
    }

    protected final AwsClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("software/amazon/awssdk/services/cognitoidentity/execution.interceptors").crc32FromCompressedDataEnabled(Boolean.valueOf(false)).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("cognito-identity");
        signer.setRegionName(this.signingRegion().value());
        return StaticSignerProvider.create((Signer)signer);
    }
}

