/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetStatus {
    PENDING("PENDING"),
    ACTIVE("ACTIVE"),
    UNREACHABLE("UNREACHABLE"),
    INACTIVE("INACTIVE"),
    DEACTIVATED("DEACTIVATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetStatus> VALUE_MAP;
    private final String value;

    private TargetStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetStatus> knownValues() {
        EnumSet<TargetStatus> knownValues = EnumSet.allOf(TargetStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetStatus.class, TargetStatus::toString);
    }
}

