/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarnotifications.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestarnotifications.model.TargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetSummary> {
    private static final SdkField<String> TARGET_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAddress").getter(TargetSummary.getter(TargetSummary::targetAddress)).setter(TargetSummary.setter(Builder::targetAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAddress").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(TargetSummary.getter(TargetSummary::targetType)).setter(TargetSummary.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> TARGET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetStatus").getter(TargetSummary.getter(TargetSummary::targetStatusAsString)).setter(TargetSummary.setter(Builder::targetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ADDRESS_FIELD, TARGET_TYPE_FIELD, TARGET_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetAddress;
    private final String targetType;
    private final String targetStatus;

    private TargetSummary(BuilderImpl builder) {
        this.targetAddress = builder.targetAddress;
        this.targetType = builder.targetType;
        this.targetStatus = builder.targetStatus;
    }

    public final String targetAddress() {
        return this.targetAddress;
    }

    public final String targetType() {
        return this.targetType;
    }

    public final TargetStatus targetStatus() {
        return TargetStatus.fromValue(this.targetStatus);
    }

    public final String targetStatusAsString() {
        return this.targetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetSummary)) {
            return false;
        }
        TargetSummary other = (TargetSummary)obj;
        return Objects.equals(this.targetAddress(), other.targetAddress()) && Objects.equals(this.targetType(), other.targetType()) && Objects.equals(this.targetStatusAsString(), other.targetStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TargetSummary").add("TargetAddress", (Object)(this.targetAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("TargetType", (Object)this.targetType()).add("TargetStatus", (Object)this.targetStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetAddress": {
                return Optional.ofNullable(clazz.cast(this.targetAddress()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetType()));
            }
            case "TargetStatus": {
                return Optional.ofNullable(clazz.cast(this.targetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetSummary, T> g) {
        return obj -> g.apply((TargetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetAddress;
        private String targetType;
        private String targetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetSummary model) {
            this.targetAddress(model.targetAddress);
            this.targetType(model.targetType);
            this.targetStatus(model.targetStatus);
        }

        public final String getTargetAddress() {
            return this.targetAddress;
        }

        @Override
        public final Builder targetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
            return this;
        }

        public final void setTargetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        public final String getTargetStatus() {
            return this.targetStatus;
        }

        @Override
        public final Builder targetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
            return this;
        }

        @Override
        public final Builder targetStatus(TargetStatus targetStatus) {
            this.targetStatus(targetStatus == null ? null : targetStatus.toString());
            return this;
        }

        public final void setTargetStatus(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        public TargetSummary build() {
            return new TargetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetSummary> {
        public Builder targetAddress(String var1);

        public Builder targetType(String var1);

        public Builder targetStatus(String var1);

        public Builder targetStatus(TargetStatus var1);
    }
}

