/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codestarconnections.model.CodeStarConnectionsResponse;
import software.amazon.awssdk.services.codestarconnections.model.RepositoryLinkInfo;
import software.amazon.awssdk.services.codestarconnections.model.RepositoryLinkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRepositoryLinksResponse
extends CodeStarConnectionsResponse
implements ToCopyableBuilder<Builder, ListRepositoryLinksResponse> {
    private static final SdkField<List<RepositoryLinkInfo>> REPOSITORY_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RepositoryLinks").getter(ListRepositoryLinksResponse.getter(ListRepositoryLinksResponse::repositoryLinks)).setter(ListRepositoryLinksResponse.setter(Builder::repositoryLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryLinkInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRepositoryLinksResponse.getter(ListRepositoryLinksResponse::nextToken)).setter(ListRepositoryLinksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_LINKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRepositoryLinksResponse.memberNameToFieldInitializer();
    private final List<RepositoryLinkInfo> repositoryLinks;
    private final String nextToken;

    private ListRepositoryLinksResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryLinks = builder.repositoryLinks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRepositoryLinks() {
        return this.repositoryLinks != null && !(this.repositoryLinks instanceof SdkAutoConstructList);
    }

    public final List<RepositoryLinkInfo> repositoryLinks() {
        return this.repositoryLinks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoryLinks() ? this.repositoryLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoryLinksResponse)) {
            return false;
        }
        ListRepositoryLinksResponse other = (ListRepositoryLinksResponse)((Object)obj);
        return this.hasRepositoryLinks() == other.hasRepositoryLinks() && Objects.equals(this.repositoryLinks(), other.repositoryLinks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRepositoryLinksResponse").add("RepositoryLinks", this.hasRepositoryLinks() ? this.repositoryLinks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryLinks": {
                return Optional.ofNullable(clazz.cast(this.repositoryLinks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RepositoryLinks", REPOSITORY_LINKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoryLinksResponse, T> g) {
        return obj -> g.apply((ListRepositoryLinksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarConnectionsResponse.BuilderImpl
    implements Builder {
        private List<RepositoryLinkInfo> repositoryLinks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoryLinksResponse model) {
            super(model);
            this.repositoryLinks(model.repositoryLinks);
            this.nextToken(model.nextToken);
        }

        public final List<RepositoryLinkInfo.Builder> getRepositoryLinks() {
            List<RepositoryLinkInfo.Builder> result = RepositoryLinkListCopier.copyToBuilder(this.repositoryLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRepositoryLinks(Collection<RepositoryLinkInfo.BuilderImpl> repositoryLinks) {
            this.repositoryLinks = RepositoryLinkListCopier.copyFromBuilder(repositoryLinks);
        }

        @Override
        public final Builder repositoryLinks(Collection<RepositoryLinkInfo> repositoryLinks) {
            this.repositoryLinks = RepositoryLinkListCopier.copy(repositoryLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryLinks(RepositoryLinkInfo ... repositoryLinks) {
            this.repositoryLinks(Arrays.asList(repositoryLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryLinks(Consumer<RepositoryLinkInfo.Builder> ... repositoryLinks) {
            this.repositoryLinks(Stream.of(repositoryLinks).map(c -> (RepositoryLinkInfo)((RepositoryLinkInfo.Builder)RepositoryLinkInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRepositoryLinksResponse build() {
            return new ListRepositoryLinksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeStarConnectionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRepositoryLinksResponse> {
        public Builder repositoryLinks(Collection<RepositoryLinkInfo> var1);

        public Builder repositoryLinks(RepositoryLinkInfo ... var1);

        public Builder repositoryLinks(Consumer<RepositoryLinkInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

