/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestarconnections.model.ProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryLinkInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryLinkInfo> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(RepositoryLinkInfo.getter(RepositoryLinkInfo::connectionArn)).setter(RepositoryLinkInfo.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(RepositoryLinkInfo.getter(RepositoryLinkInfo::encryptionKeyArn)).setter(RepositoryLinkInfo.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(RepositoryLinkInfo.getter(RepositoryLinkInfo::ownerId)).setter(RepositoryLinkInfo.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(RepositoryLinkInfo.getter(RepositoryLinkInfo::providerTypeAsString)).setter(RepositoryLinkInfo.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> REPOSITORY_LINK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryLinkArn").getter(RepositoryLinkInfo.getter(RepositoryLinkInfo::repositoryLinkArn)).setter(RepositoryLinkInfo.setter(Builder::repositoryLinkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkArn").build()}).build();
    private static final SdkField<String> REPOSITORY_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryLinkId").getter(RepositoryLinkInfo.getter(RepositoryLinkInfo::repositoryLinkId)).setter(RepositoryLinkInfo.setter(Builder::repositoryLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryLinkId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryName").getter(RepositoryLinkInfo.getter(RepositoryLinkInfo::repositoryName)).setter(RepositoryLinkInfo.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD, ENCRYPTION_KEY_ARN_FIELD, OWNER_ID_FIELD, PROVIDER_TYPE_FIELD, REPOSITORY_LINK_ARN_FIELD, REPOSITORY_LINK_ID_FIELD, REPOSITORY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RepositoryLinkInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectionArn;
    private final String encryptionKeyArn;
    private final String ownerId;
    private final String providerType;
    private final String repositoryLinkArn;
    private final String repositoryLinkId;
    private final String repositoryName;

    private RepositoryLinkInfo(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.ownerId = builder.ownerId;
        this.providerType = builder.providerType;
        this.repositoryLinkArn = builder.repositoryLinkArn;
        this.repositoryLinkId = builder.repositoryLinkId;
        this.repositoryName = builder.repositoryName;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final ProviderType providerType() {
        return ProviderType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public final String repositoryLinkArn() {
        return this.repositoryLinkArn;
    }

    public final String repositoryLinkId() {
        return this.repositoryLinkId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryLinkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryLinkInfo)) {
            return false;
        }
        RepositoryLinkInfo other = (RepositoryLinkInfo)obj;
        return Objects.equals(this.connectionArn(), other.connectionArn()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.repositoryLinkArn(), other.repositoryLinkArn()) && Objects.equals(this.repositoryLinkId(), other.repositoryLinkId()) && Objects.equals(this.repositoryName(), other.repositoryName());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryLinkInfo").add("ConnectionArn", (Object)this.connectionArn()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("OwnerId", (Object)this.ownerId()).add("ProviderType", (Object)this.providerTypeAsString()).add("RepositoryLinkArn", (Object)this.repositoryLinkArn()).add("RepositoryLinkId", (Object)this.repositoryLinkId()).add("RepositoryName", (Object)this.repositoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "RepositoryLinkArn": {
                return Optional.ofNullable(clazz.cast(this.repositoryLinkArn()));
            }
            case "RepositoryLinkId": {
                return Optional.ofNullable(clazz.cast(this.repositoryLinkId()));
            }
            case "RepositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectionArn", CONNECTION_ARN_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("ProviderType", PROVIDER_TYPE_FIELD);
        map.put("RepositoryLinkArn", REPOSITORY_LINK_ARN_FIELD);
        map.put("RepositoryLinkId", REPOSITORY_LINK_ID_FIELD);
        map.put("RepositoryName", REPOSITORY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RepositoryLinkInfo, T> g) {
        return obj -> g.apply((RepositoryLinkInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionArn;
        private String encryptionKeyArn;
        private String ownerId;
        private String providerType;
        private String repositoryLinkArn;
        private String repositoryLinkId;
        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryLinkInfo model) {
            this.connectionArn(model.connectionArn);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.ownerId(model.ownerId);
            this.providerType(model.providerType);
            this.repositoryLinkArn(model.repositoryLinkArn);
            this.repositoryLinkId(model.repositoryLinkId);
            this.repositoryName(model.repositoryName);
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getRepositoryLinkArn() {
            return this.repositoryLinkArn;
        }

        public final void setRepositoryLinkArn(String repositoryLinkArn) {
            this.repositoryLinkArn = repositoryLinkArn;
        }

        @Override
        public final Builder repositoryLinkArn(String repositoryLinkArn) {
            this.repositoryLinkArn = repositoryLinkArn;
            return this;
        }

        public final String getRepositoryLinkId() {
            return this.repositoryLinkId;
        }

        public final void setRepositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
        }

        @Override
        public final Builder repositoryLinkId(String repositoryLinkId) {
            this.repositoryLinkId = repositoryLinkId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public RepositoryLinkInfo build() {
            return new RepositoryLinkInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryLinkInfo> {
        public Builder connectionArn(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder ownerId(String var1);

        public Builder providerType(String var1);

        public Builder providerType(ProviderType var1);

        public Builder repositoryLinkArn(String var1);

        public Builder repositoryLinkId(String var1);

        public Builder repositoryName(String var1);
    }
}

