/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codestarconnections.model.LatestSyncBlockerListCopier;
import software.amazon.awssdk.services.codestarconnections.model.SyncBlocker;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SyncBlockerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SyncBlockerSummary> {
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(SyncBlockerSummary.getter(SyncBlockerSummary::resourceName)).setter(SyncBlockerSummary.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> PARENT_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentResourceName").getter(SyncBlockerSummary.getter(SyncBlockerSummary::parentResourceName)).setter(SyncBlockerSummary.setter(Builder::parentResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentResourceName").build()}).build();
    private static final SdkField<List<SyncBlocker>> LATEST_BLOCKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LatestBlockers").getter(SyncBlockerSummary.getter(SyncBlockerSummary::latestBlockers)).setter(SyncBlockerSummary.setter(Builder::latestBlockers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestBlockers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SyncBlocker::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_NAME_FIELD, PARENT_RESOURCE_NAME_FIELD, LATEST_BLOCKERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceName", RESOURCE_NAME_FIELD);
            this.put("ParentResourceName", PARENT_RESOURCE_NAME_FIELD);
            this.put("LatestBlockers", LATEST_BLOCKERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String resourceName;
    private final String parentResourceName;
    private final List<SyncBlocker> latestBlockers;

    private SyncBlockerSummary(BuilderImpl builder) {
        this.resourceName = builder.resourceName;
        this.parentResourceName = builder.parentResourceName;
        this.latestBlockers = builder.latestBlockers;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final String parentResourceName() {
        return this.parentResourceName;
    }

    public final boolean hasLatestBlockers() {
        return this.latestBlockers != null && !(this.latestBlockers instanceof SdkAutoConstructList);
    }

    public final List<SyncBlocker> latestBlockers() {
        return this.latestBlockers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLatestBlockers() ? this.latestBlockers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SyncBlockerSummary)) {
            return false;
        }
        SyncBlockerSummary other = (SyncBlockerSummary)obj;
        return Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.parentResourceName(), other.parentResourceName()) && this.hasLatestBlockers() == other.hasLatestBlockers() && Objects.equals(this.latestBlockers(), other.latestBlockers());
    }

    public final String toString() {
        return ToString.builder((String)"SyncBlockerSummary").add("ResourceName", (Object)this.resourceName()).add("ParentResourceName", (Object)this.parentResourceName()).add("LatestBlockers", this.hasLatestBlockers() ? this.latestBlockers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "ParentResourceName": {
                return Optional.ofNullable(clazz.cast(this.parentResourceName()));
            }
            case "LatestBlockers": {
                return Optional.ofNullable(clazz.cast(this.latestBlockers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SyncBlockerSummary, T> g) {
        return obj -> g.apply((SyncBlockerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceName;
        private String parentResourceName;
        private List<SyncBlocker> latestBlockers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SyncBlockerSummary model) {
            this.resourceName(model.resourceName);
            this.parentResourceName(model.parentResourceName);
            this.latestBlockers(model.latestBlockers);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getParentResourceName() {
            return this.parentResourceName;
        }

        public final void setParentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
        }

        @Override
        public final Builder parentResourceName(String parentResourceName) {
            this.parentResourceName = parentResourceName;
            return this;
        }

        public final List<SyncBlocker.Builder> getLatestBlockers() {
            List<SyncBlocker.Builder> result = LatestSyncBlockerListCopier.copyToBuilder(this.latestBlockers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestBlockers(Collection<SyncBlocker.BuilderImpl> latestBlockers) {
            this.latestBlockers = LatestSyncBlockerListCopier.copyFromBuilder(latestBlockers);
        }

        @Override
        public final Builder latestBlockers(Collection<SyncBlocker> latestBlockers) {
            this.latestBlockers = LatestSyncBlockerListCopier.copy(latestBlockers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestBlockers(SyncBlocker ... latestBlockers) {
            this.latestBlockers(Arrays.asList(latestBlockers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestBlockers(Consumer<SyncBlocker.Builder> ... latestBlockers) {
            this.latestBlockers(Stream.of(latestBlockers).map(c -> (SyncBlocker)((SyncBlocker.Builder)SyncBlocker.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SyncBlockerSummary build() {
            return new SyncBlockerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SyncBlockerSummary> {
        public Builder resourceName(String var1);

        public Builder parentResourceName(String var1);

        public Builder latestBlockers(Collection<SyncBlocker> var1);

        public Builder latestBlockers(SyncBlocker ... var1);

        public Builder latestBlockers(Consumer<SyncBlocker.Builder> ... var1);
    }
}

