/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestarconnections.model.ProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Revision
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Revision> {
    private static final SdkField<String> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Branch").getter(Revision.getter(Revision::branch)).setter(Revision.setter(Builder::branch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Branch").build()}).build();
    private static final SdkField<String> DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Directory").getter(Revision.getter(Revision::directory)).setter(Revision.setter(Builder::directory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Directory").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(Revision.getter(Revision::ownerId)).setter(Revision.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryName").getter(Revision.getter(Revision::repositoryName)).setter(Revision.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryName").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(Revision.getter(Revision::providerTypeAsString)).setter(Revision.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> SHA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sha").getter(Revision.getter(Revision::sha)).setter(Revision.setter(Builder::sha)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sha").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, DIRECTORY_FIELD, OWNER_ID_FIELD, REPOSITORY_NAME_FIELD, PROVIDER_TYPE_FIELD, SHA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String branch;
    private final String directory;
    private final String ownerId;
    private final String repositoryName;
    private final String providerType;
    private final String sha;

    private Revision(BuilderImpl builder) {
        this.branch = builder.branch;
        this.directory = builder.directory;
        this.ownerId = builder.ownerId;
        this.repositoryName = builder.repositoryName;
        this.providerType = builder.providerType;
        this.sha = builder.sha;
    }

    public final String branch() {
        return this.branch;
    }

    public final String directory() {
        return this.directory;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final ProviderType providerType() {
        return ProviderType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public final String sha() {
        return this.sha;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.directory());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sha());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)obj;
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.directory(), other.directory()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.sha(), other.sha());
    }

    public final String toString() {
        return ToString.builder((String)"Revision").add("Branch", (Object)this.branch()).add("Directory", (Object)this.directory()).add("OwnerId", (Object)this.ownerId()).add("RepositoryName", (Object)this.repositoryName()).add("ProviderType", (Object)this.providerTypeAsString()).add("Sha", (Object)this.sha()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "Directory": {
                return Optional.ofNullable(clazz.cast(this.directory()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "RepositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "Sha": {
                return Optional.ofNullable(clazz.cast(this.sha()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Revision, T> g) {
        return obj -> g.apply((Revision)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String branch;
        private String directory;
        private String ownerId;
        private String repositoryName;
        private String providerType;
        private String sha;

        private BuilderImpl() {
        }

        private BuilderImpl(Revision model) {
            this.branch(model.branch);
            this.directory(model.directory);
            this.ownerId(model.ownerId);
            this.repositoryName(model.repositoryName);
            this.providerType(model.providerType);
            this.sha(model.sha);
        }

        public final String getBranch() {
            return this.branch;
        }

        public final void setBranch(String branch) {
            this.branch = branch;
        }

        @Override
        public final Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public final String getDirectory() {
            return this.directory;
        }

        public final void setDirectory(String directory) {
            this.directory = directory;
        }

        @Override
        public final Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getSha() {
            return this.sha;
        }

        public final void setSha(String sha) {
            this.sha = sha;
        }

        @Override
        public final Builder sha(String sha) {
            this.sha = sha;
            return this;
        }

        public Revision build() {
            return new Revision(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Revision> {
        public Builder branch(String var1);

        public Builder directory(String var1);

        public Builder ownerId(String var1);

        public Builder repositoryName(String var1);

        public Builder providerType(String var1);

        public Builder providerType(ProviderType var1);

        public Builder sha(String var1);
    }
}

