/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsClient;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsClientBuilder;
import software.amazon.awssdk.services.codestarconnections.CodeStarConnectionsServiceClientConfiguration;
import software.amazon.awssdk.services.codestarconnections.DefaultCodeStarConnectionsBaseClientBuilder;
import software.amazon.awssdk.services.codestarconnections.DefaultCodeStarConnectionsClient;
import software.amazon.awssdk.services.codestarconnections.endpoints.CodeStarConnectionsEndpointProvider;

@SdkInternalApi
final class DefaultCodeStarConnectionsClientBuilder
extends DefaultCodeStarConnectionsBaseClientBuilder<CodeStarConnectionsClientBuilder, CodeStarConnectionsClient>
implements CodeStarConnectionsClientBuilder {
    DefaultCodeStarConnectionsClientBuilder() {
    }

    @Override
    public DefaultCodeStarConnectionsClientBuilder endpointProvider(CodeStarConnectionsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CodeStarConnectionsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCodeStarConnectionsClientBuilder.validateClientOptions(clientConfiguration);
        CodeStarConnectionsServiceClientConfiguration serviceClientConfiguration = CodeStarConnectionsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultCodeStarConnectionsClient(serviceClientConfiguration, clientConfiguration);
    }
}

