/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionResult;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetail;
import software.amazon.awssdk.services.codepipeline.model.ArtifactDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionExecutionOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionExecutionOutput> {
    private static final SdkField<List<ArtifactDetail>> OUTPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ActionExecutionOutput.getter(ActionExecutionOutput::outputArtifacts)).setter(ActionExecutionOutput.setter(Builder::outputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ActionExecutionResult> EXECUTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ActionExecutionOutput.getter(ActionExecutionOutput::executionResult)).setter(ActionExecutionOutput.setter(Builder::executionResult)).constructor(ActionExecutionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_ARTIFACTS_FIELD, EXECUTION_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ArtifactDetail> outputArtifacts;
    private final ActionExecutionResult executionResult;

    private ActionExecutionOutput(BuilderImpl builder) {
        this.outputArtifacts = builder.outputArtifacts;
        this.executionResult = builder.executionResult;
    }

    public List<ArtifactDetail> outputArtifacts() {
        return this.outputArtifacts;
    }

    public ActionExecutionResult executionResult() {
        return this.executionResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionResult());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionOutput)) {
            return false;
        }
        ActionExecutionOutput other = (ActionExecutionOutput)obj;
        return Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && Objects.equals(this.executionResult(), other.executionResult());
    }

    public String toString() {
        return ToString.builder((String)"ActionExecutionOutput").add("OutputArtifacts", this.outputArtifacts()).add("ExecutionResult", (Object)this.executionResult()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.outputArtifacts()));
            }
            case "executionResult": {
                return Optional.ofNullable(clazz.cast(this.executionResult()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionOutput, T> g) {
        return obj -> g.apply((ActionExecutionOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ArtifactDetail> outputArtifacts = DefaultSdkAutoConstructList.getInstance();
        private ActionExecutionResult executionResult;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionOutput model) {
            this.outputArtifacts(model.outputArtifacts);
            this.executionResult(model.executionResult);
        }

        public final Collection<ArtifactDetail.Builder> getOutputArtifacts() {
            return this.outputArtifacts != null ? (Collection)this.outputArtifacts.stream().map(ArtifactDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder outputArtifacts(Collection<ArtifactDetail> outputArtifacts) {
            this.outputArtifacts = ArtifactDetailListCopier.copy(outputArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(ArtifactDetail ... outputArtifacts) {
            this.outputArtifacts(Arrays.asList(outputArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputArtifacts(Consumer<ArtifactDetail.Builder> ... outputArtifacts) {
            this.outputArtifacts(Stream.of(outputArtifacts).map(c -> (ArtifactDetail)((ArtifactDetail.Builder)ArtifactDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOutputArtifacts(Collection<ArtifactDetail.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = ArtifactDetailListCopier.copyFromBuilder(outputArtifacts);
        }

        public final ActionExecutionResult.Builder getExecutionResult() {
            return this.executionResult != null ? this.executionResult.toBuilder() : null;
        }

        @Override
        public final Builder executionResult(ActionExecutionResult executionResult) {
            this.executionResult = executionResult;
            return this;
        }

        public final void setExecutionResult(ActionExecutionResult.BuilderImpl executionResult) {
            this.executionResult = executionResult != null ? executionResult.build() : null;
        }

        public ActionExecutionOutput build() {
            return new ActionExecutionOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionExecutionOutput> {
        public Builder outputArtifacts(Collection<ArtifactDetail> var1);

        public Builder outputArtifacts(ArtifactDetail ... var1);

        public Builder outputArtifacts(Consumer<ArtifactDetail.Builder> ... var1);

        public Builder executionResult(ActionExecutionResult var1);

        default public Builder executionResult(Consumer<ActionExecutionResult.Builder> executionResult) {
            return this.executionResult((ActionExecutionResult)((ActionExecutionResult.Builder)ActionExecutionResult.builder().applyMutation(executionResult)).build());
        }
    }
}

