/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BlockerType {
    SCHEDULE("Schedule"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BlockerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlockerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BlockerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlockerType> knownValues() {
        return Stream.of(BlockerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

