/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionInput;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionOutput;
import software.amazon.awssdk.services.codepipeline.model.ActionExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionExecutionDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionExecutionDetail> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionExecutionDetail.getter(ActionExecutionDetail::pipelineExecutionId)).setter(ActionExecutionDetail.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final SdkField<String> ACTION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionExecutionDetail.getter(ActionExecutionDetail::actionExecutionId)).setter(ActionExecutionDetail.setter(Builder::actionExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionId").build()}).build();
    private static final SdkField<Integer> PIPELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ActionExecutionDetail.getter(ActionExecutionDetail::pipelineVersion)).setter(ActionExecutionDetail.setter(Builder::pipelineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineVersion").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionExecutionDetail.getter(ActionExecutionDetail::stageName)).setter(ActionExecutionDetail.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionExecutionDetail.getter(ActionExecutionDetail::actionName)).setter(ActionExecutionDetail.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ActionExecutionDetail.getter(ActionExecutionDetail::startTime)).setter(ActionExecutionDetail.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ActionExecutionDetail.getter(ActionExecutionDetail::lastUpdateTime)).setter(ActionExecutionDetail.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionExecutionDetail.getter(ActionExecutionDetail::statusAsString)).setter(ActionExecutionDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ActionExecutionInput> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ActionExecutionDetail.getter(ActionExecutionDetail::input)).setter(ActionExecutionDetail.setter(Builder::input)).constructor(ActionExecutionInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<ActionExecutionOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ActionExecutionDetail.getter(ActionExecutionDetail::output)).setter(ActionExecutionDetail.setter(Builder::output)).constructor(ActionExecutionOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD, ACTION_EXECUTION_ID_FIELD, PIPELINE_VERSION_FIELD, STAGE_NAME_FIELD, ACTION_NAME_FIELD, START_TIME_FIELD, LAST_UPDATE_TIME_FIELD, STATUS_FIELD, INPUT_FIELD, OUTPUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String pipelineExecutionId;
    private final String actionExecutionId;
    private final Integer pipelineVersion;
    private final String stageName;
    private final String actionName;
    private final Instant startTime;
    private final Instant lastUpdateTime;
    private final String status;
    private final ActionExecutionInput input;
    private final ActionExecutionOutput output;

    private ActionExecutionDetail(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.actionExecutionId = builder.actionExecutionId;
        this.pipelineVersion = builder.pipelineVersion;
        this.stageName = builder.stageName;
        this.actionName = builder.actionName;
        this.startTime = builder.startTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.status = builder.status;
        this.input = builder.input;
        this.output = builder.output;
    }

    public String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public String actionExecutionId() {
        return this.actionExecutionId;
    }

    public Integer pipelineVersion() {
        return this.pipelineVersion;
    }

    public String stageName() {
        return this.stageName;
    }

    public String actionName() {
        return this.actionName;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public ActionExecutionStatus status() {
        return ActionExecutionStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public ActionExecutionInput input() {
        return this.input;
    }

    public ActionExecutionOutput output() {
        return this.output;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionExecutionDetail)) {
            return false;
        }
        ActionExecutionDetail other = (ActionExecutionDetail)obj;
        return Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.actionExecutionId(), other.actionExecutionId()) && Objects.equals(this.pipelineVersion(), other.pipelineVersion()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.output(), other.output());
    }

    public String toString() {
        return ToString.builder((String)"ActionExecutionDetail").add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("ActionExecutionId", (Object)this.actionExecutionId()).add("PipelineVersion", (Object)this.pipelineVersion()).add("StageName", (Object)this.stageName()).add("ActionName", (Object)this.actionName()).add("StartTime", (Object)this.startTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("Status", (Object)this.statusAsString()).add("Input", (Object)this.input()).add("Output", (Object)this.output()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
            case "actionExecutionId": {
                return Optional.ofNullable(clazz.cast(this.actionExecutionId()));
            }
            case "pipelineVersion": {
                return Optional.ofNullable(clazz.cast(this.pipelineVersion()));
            }
            case "stageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionExecutionDetail, T> g) {
        return obj -> g.apply((ActionExecutionDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineExecutionId;
        private String actionExecutionId;
        private Integer pipelineVersion;
        private String stageName;
        private String actionName;
        private Instant startTime;
        private Instant lastUpdateTime;
        private String status;
        private ActionExecutionInput input;
        private ActionExecutionOutput output;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionExecutionDetail model) {
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.actionExecutionId(model.actionExecutionId);
            this.pipelineVersion(model.pipelineVersion);
            this.stageName(model.stageName);
            this.actionName(model.actionName);
            this.startTime(model.startTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.status(model.status);
            this.input(model.input);
            this.output(model.output);
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        public final String getActionExecutionId() {
            return this.actionExecutionId;
        }

        @Override
        public final Builder actionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
            return this;
        }

        public final void setActionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
        }

        public final Integer getPipelineVersion() {
            return this.pipelineVersion;
        }

        @Override
        public final Builder pipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
            return this;
        }

        public final void setPipelineVersion(Integer pipelineVersion) {
            this.pipelineVersion = pipelineVersion;
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final String getActionName() {
            return this.actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ActionExecutionInput.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        @Override
        public final Builder input(ActionExecutionInput input) {
            this.input = input;
            return this;
        }

        public final void setInput(ActionExecutionInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        public final ActionExecutionOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        @Override
        public final Builder output(ActionExecutionOutput output) {
            this.output = output;
            return this;
        }

        public final void setOutput(ActionExecutionOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        public ActionExecutionDetail build() {
            return new ActionExecutionDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionExecutionDetail> {
        public Builder pipelineExecutionId(String var1);

        public Builder actionExecutionId(String var1);

        public Builder pipelineVersion(Integer var1);

        public Builder stageName(String var1);

        public Builder actionName(String var1);

        public Builder startTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ActionExecutionStatus var1);

        public Builder input(ActionExecutionInput var1);

        default public Builder input(Consumer<ActionExecutionInput.Builder> input) {
            return this.input((ActionExecutionInput)((ActionExecutionInput.Builder)ActionExecutionInput.builder().applyMutation(input)).build());
        }

        public Builder output(ActionExecutionOutput var1);

        default public Builder output(Consumer<ActionExecutionOutput.Builder> output) {
            return this.output((ActionExecutionOutput)((ActionExecutionOutput.Builder)ActionExecutionOutput.builder().applyMutation(output)).build());
        }
    }
}

