/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcknowledgeThirdPartyJobRequest
extends CodePipelineRequest
implements ToCopyableBuilder<Builder, AcknowledgeThirdPartyJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AcknowledgeThirdPartyJobRequest.getter(AcknowledgeThirdPartyJobRequest::jobId)).setter(AcknowledgeThirdPartyJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> NONCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AcknowledgeThirdPartyJobRequest.getter(AcknowledgeThirdPartyJobRequest::nonce)).setter(AcknowledgeThirdPartyJobRequest.setter(Builder::nonce)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonce").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AcknowledgeThirdPartyJobRequest.getter(AcknowledgeThirdPartyJobRequest::clientToken)).setter(AcknowledgeThirdPartyJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, NONCE_FIELD, CLIENT_TOKEN_FIELD));
    private final String jobId;
    private final String nonce;
    private final String clientToken;

    private AcknowledgeThirdPartyJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.nonce = builder.nonce;
        this.clientToken = builder.clientToken;
    }

    public String jobId() {
        return this.jobId;
    }

    public String nonce() {
        return this.nonce;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonce());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeThirdPartyJobRequest)) {
            return false;
        }
        AcknowledgeThirdPartyJobRequest other = (AcknowledgeThirdPartyJobRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.nonce(), other.nonce()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"AcknowledgeThirdPartyJobRequest").add("JobId", (Object)this.jobId()).add("Nonce", (Object)this.nonce()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "nonce": {
                return Optional.ofNullable(clazz.cast(this.nonce()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcknowledgeThirdPartyJobRequest, T> g) {
        return obj -> g.apply((AcknowledgeThirdPartyJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private String nonce;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(AcknowledgeThirdPartyJobRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.nonce(model.nonce);
            this.clientToken(model.clientToken);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getNonce() {
            return this.nonce;
        }

        @Override
        public final Builder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public final void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcknowledgeThirdPartyJobRequest build() {
            return new AcknowledgeThirdPartyJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodePipelineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcknowledgeThirdPartyJobRequest> {
        public Builder jobId(String var1);

        public Builder nonce(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

