/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ExecutionMode;
import software.amazon.awssdk.services.codepipeline.model.ExecutionTrigger;
import software.amazon.awssdk.services.codepipeline.model.ExecutionType;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus;
import software.amazon.awssdk.services.codepipeline.model.PipelineRollbackMetadata;
import software.amazon.awssdk.services.codepipeline.model.SourceRevision;
import software.amazon.awssdk.services.codepipeline.model.SourceRevisionListCopier;
import software.amazon.awssdk.services.codepipeline.model.StopExecutionTrigger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipelineExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipelineExecutionSummary> {
    private static final SdkField<String> PIPELINE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pipelineExecutionId").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::pipelineExecutionId)).setter(PipelineExecutionSummary.setter(Builder::pipelineExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::statusAsString)).setter(PipelineExecutionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusSummary").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::statusSummary)).setter(PipelineExecutionSummary.setter(Builder::statusSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusSummary").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::startTime)).setter(PipelineExecutionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::lastUpdateTime)).setter(PipelineExecutionSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final SdkField<List<SourceRevision>> SOURCE_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceRevisions").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::sourceRevisions)).setter(PipelineExecutionSummary.setter(Builder::sourceRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRevisions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceRevision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExecutionTrigger> TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trigger").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::trigger)).setter(PipelineExecutionSummary.setter(Builder::trigger)).constructor(ExecutionTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trigger").build()}).build();
    private static final SdkField<StopExecutionTrigger> STOP_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stopTrigger").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::stopTrigger)).setter(PipelineExecutionSummary.setter(Builder::stopTrigger)).constructor(StopExecutionTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTrigger").build()}).build();
    private static final SdkField<String> EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionMode").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::executionModeAsString)).setter(PipelineExecutionSummary.setter(Builder::executionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionMode").build()}).build();
    private static final SdkField<String> EXECUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionType").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::executionTypeAsString)).setter(PipelineExecutionSummary.setter(Builder::executionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionType").build()}).build();
    private static final SdkField<PipelineRollbackMetadata> ROLLBACK_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rollbackMetadata").getter(PipelineExecutionSummary.getter(PipelineExecutionSummary::rollbackMetadata)).setter(PipelineExecutionSummary.setter(Builder::rollbackMetadata)).constructor(PipelineRollbackMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_ID_FIELD, STATUS_FIELD, STATUS_SUMMARY_FIELD, START_TIME_FIELD, LAST_UPDATE_TIME_FIELD, SOURCE_REVISIONS_FIELD, TRIGGER_FIELD, STOP_TRIGGER_FIELD, EXECUTION_MODE_FIELD, EXECUTION_TYPE_FIELD, ROLLBACK_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipelineExecutionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pipelineExecutionId;
    private final String status;
    private final String statusSummary;
    private final Instant startTime;
    private final Instant lastUpdateTime;
    private final List<SourceRevision> sourceRevisions;
    private final ExecutionTrigger trigger;
    private final StopExecutionTrigger stopTrigger;
    private final String executionMode;
    private final String executionType;
    private final PipelineRollbackMetadata rollbackMetadata;

    private PipelineExecutionSummary(BuilderImpl builder) {
        this.pipelineExecutionId = builder.pipelineExecutionId;
        this.status = builder.status;
        this.statusSummary = builder.statusSummary;
        this.startTime = builder.startTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.sourceRevisions = builder.sourceRevisions;
        this.trigger = builder.trigger;
        this.stopTrigger = builder.stopTrigger;
        this.executionMode = builder.executionMode;
        this.executionType = builder.executionType;
        this.rollbackMetadata = builder.rollbackMetadata;
    }

    public final String pipelineExecutionId() {
        return this.pipelineExecutionId;
    }

    public final PipelineExecutionStatus status() {
        return PipelineExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusSummary() {
        return this.statusSummary;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final boolean hasSourceRevisions() {
        return this.sourceRevisions != null && !(this.sourceRevisions instanceof SdkAutoConstructList);
    }

    public final List<SourceRevision> sourceRevisions() {
        return this.sourceRevisions;
    }

    public final ExecutionTrigger trigger() {
        return this.trigger;
    }

    public final StopExecutionTrigger stopTrigger() {
        return this.stopTrigger;
    }

    public final ExecutionMode executionMode() {
        return ExecutionMode.fromValue(this.executionMode);
    }

    public final String executionModeAsString() {
        return this.executionMode;
    }

    public final ExecutionType executionType() {
        return ExecutionType.fromValue(this.executionType);
    }

    public final String executionTypeAsString() {
        return this.executionType;
    }

    public final PipelineRollbackMetadata rollbackMetadata() {
        return this.rollbackMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceRevisions() ? this.sourceRevisions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTrigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecutionSummary)) {
            return false;
        }
        PipelineExecutionSummary other = (PipelineExecutionSummary)obj;
        return Objects.equals(this.pipelineExecutionId(), other.pipelineExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusSummary(), other.statusSummary()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && this.hasSourceRevisions() == other.hasSourceRevisions() && Objects.equals(this.sourceRevisions(), other.sourceRevisions()) && Objects.equals(this.trigger(), other.trigger()) && Objects.equals(this.stopTrigger(), other.stopTrigger()) && Objects.equals(this.executionModeAsString(), other.executionModeAsString()) && Objects.equals(this.executionTypeAsString(), other.executionTypeAsString()) && Objects.equals(this.rollbackMetadata(), other.rollbackMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"PipelineExecutionSummary").add("PipelineExecutionId", (Object)this.pipelineExecutionId()).add("Status", (Object)this.statusAsString()).add("StatusSummary", (Object)this.statusSummary()).add("StartTime", (Object)this.startTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("SourceRevisions", this.hasSourceRevisions() ? this.sourceRevisions() : null).add("Trigger", (Object)this.trigger()).add("StopTrigger", (Object)this.stopTrigger()).add("ExecutionMode", (Object)this.executionModeAsString()).add("ExecutionType", (Object)this.executionTypeAsString()).add("RollbackMetadata", (Object)this.rollbackMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineExecutionId": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusSummary": {
                return Optional.ofNullable(clazz.cast(this.statusSummary()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "sourceRevisions": {
                return Optional.ofNullable(clazz.cast(this.sourceRevisions()));
            }
            case "trigger": {
                return Optional.ofNullable(clazz.cast(this.trigger()));
            }
            case "stopTrigger": {
                return Optional.ofNullable(clazz.cast(this.stopTrigger()));
            }
            case "executionMode": {
                return Optional.ofNullable(clazz.cast(this.executionModeAsString()));
            }
            case "executionType": {
                return Optional.ofNullable(clazz.cast(this.executionTypeAsString()));
            }
            case "rollbackMetadata": {
                return Optional.ofNullable(clazz.cast(this.rollbackMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pipelineExecutionId", PIPELINE_EXECUTION_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusSummary", STATUS_SUMMARY_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("sourceRevisions", SOURCE_REVISIONS_FIELD);
        map.put("trigger", TRIGGER_FIELD);
        map.put("stopTrigger", STOP_TRIGGER_FIELD);
        map.put("executionMode", EXECUTION_MODE_FIELD);
        map.put("executionType", EXECUTION_TYPE_FIELD);
        map.put("rollbackMetadata", ROLLBACK_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipelineExecutionSummary, T> g) {
        return obj -> g.apply((PipelineExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineExecutionId;
        private String status;
        private String statusSummary;
        private Instant startTime;
        private Instant lastUpdateTime;
        private List<SourceRevision> sourceRevisions = DefaultSdkAutoConstructList.getInstance();
        private ExecutionTrigger trigger;
        private StopExecutionTrigger stopTrigger;
        private String executionMode;
        private String executionType;
        private PipelineRollbackMetadata rollbackMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineExecutionSummary model) {
            this.pipelineExecutionId(model.pipelineExecutionId);
            this.status(model.status);
            this.statusSummary(model.statusSummary);
            this.startTime(model.startTime);
            this.lastUpdateTime(model.lastUpdateTime);
            this.sourceRevisions(model.sourceRevisions);
            this.trigger(model.trigger);
            this.stopTrigger(model.stopTrigger);
            this.executionMode(model.executionMode);
            this.executionType(model.executionType);
            this.rollbackMetadata(model.rollbackMetadata);
        }

        public final String getPipelineExecutionId() {
            return this.pipelineExecutionId;
        }

        public final void setPipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
        }

        @Override
        public final Builder pipelineExecutionId(String pipelineExecutionId) {
            this.pipelineExecutionId = pipelineExecutionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PipelineExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusSummary() {
            return this.statusSummary;
        }

        public final void setStatusSummary(String statusSummary) {
            this.statusSummary = statusSummary;
        }

        @Override
        public final Builder statusSummary(String statusSummary) {
            this.statusSummary = statusSummary;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final List<SourceRevision.Builder> getSourceRevisions() {
            List<SourceRevision.Builder> result = SourceRevisionListCopier.copyToBuilder(this.sourceRevisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceRevisions(Collection<SourceRevision.BuilderImpl> sourceRevisions) {
            this.sourceRevisions = SourceRevisionListCopier.copyFromBuilder(sourceRevisions);
        }

        @Override
        public final Builder sourceRevisions(Collection<SourceRevision> sourceRevisions) {
            this.sourceRevisions = SourceRevisionListCopier.copy(sourceRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRevisions(SourceRevision ... sourceRevisions) {
            this.sourceRevisions(Arrays.asList(sourceRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRevisions(Consumer<SourceRevision.Builder> ... sourceRevisions) {
            this.sourceRevisions(Stream.of(sourceRevisions).map(c -> (SourceRevision)((SourceRevision.Builder)SourceRevision.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ExecutionTrigger.Builder getTrigger() {
            return this.trigger != null ? this.trigger.toBuilder() : null;
        }

        public final void setTrigger(ExecutionTrigger.BuilderImpl trigger) {
            this.trigger = trigger != null ? trigger.build() : null;
        }

        @Override
        public final Builder trigger(ExecutionTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public final StopExecutionTrigger.Builder getStopTrigger() {
            return this.stopTrigger != null ? this.stopTrigger.toBuilder() : null;
        }

        public final void setStopTrigger(StopExecutionTrigger.BuilderImpl stopTrigger) {
            this.stopTrigger = stopTrigger != null ? stopTrigger.build() : null;
        }

        @Override
        public final Builder stopTrigger(StopExecutionTrigger stopTrigger) {
            this.stopTrigger = stopTrigger;
            return this;
        }

        public final String getExecutionMode() {
            return this.executionMode;
        }

        public final void setExecutionMode(String executionMode) {
            this.executionMode = executionMode;
        }

        @Override
        public final Builder executionMode(String executionMode) {
            this.executionMode = executionMode;
            return this;
        }

        @Override
        public final Builder executionMode(ExecutionMode executionMode) {
            this.executionMode(executionMode == null ? null : executionMode.toString());
            return this;
        }

        public final String getExecutionType() {
            return this.executionType;
        }

        public final void setExecutionType(String executionType) {
            this.executionType = executionType;
        }

        @Override
        public final Builder executionType(String executionType) {
            this.executionType = executionType;
            return this;
        }

        @Override
        public final Builder executionType(ExecutionType executionType) {
            this.executionType(executionType == null ? null : executionType.toString());
            return this;
        }

        public final PipelineRollbackMetadata.Builder getRollbackMetadata() {
            return this.rollbackMetadata != null ? this.rollbackMetadata.toBuilder() : null;
        }

        public final void setRollbackMetadata(PipelineRollbackMetadata.BuilderImpl rollbackMetadata) {
            this.rollbackMetadata = rollbackMetadata != null ? rollbackMetadata.build() : null;
        }

        @Override
        public final Builder rollbackMetadata(PipelineRollbackMetadata rollbackMetadata) {
            this.rollbackMetadata = rollbackMetadata;
            return this;
        }

        public PipelineExecutionSummary build() {
            return new PipelineExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipelineExecutionSummary> {
        public Builder pipelineExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(PipelineExecutionStatus var1);

        public Builder statusSummary(String var1);

        public Builder startTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder sourceRevisions(Collection<SourceRevision> var1);

        public Builder sourceRevisions(SourceRevision ... var1);

        public Builder sourceRevisions(Consumer<SourceRevision.Builder> ... var1);

        public Builder trigger(ExecutionTrigger var1);

        default public Builder trigger(Consumer<ExecutionTrigger.Builder> trigger) {
            return this.trigger((ExecutionTrigger)((ExecutionTrigger.Builder)ExecutionTrigger.builder().applyMutation(trigger)).build());
        }

        public Builder stopTrigger(StopExecutionTrigger var1);

        default public Builder stopTrigger(Consumer<StopExecutionTrigger.Builder> stopTrigger) {
            return this.stopTrigger((StopExecutionTrigger)((StopExecutionTrigger.Builder)StopExecutionTrigger.builder().applyMutation(stopTrigger)).build());
        }

        public Builder executionMode(String var1);

        public Builder executionMode(ExecutionMode var1);

        public Builder executionType(String var1);

        public Builder executionType(ExecutionType var1);

        public Builder rollbackMetadata(PipelineRollbackMetadata var1);

        default public Builder rollbackMetadata(Consumer<PipelineRollbackMetadata.Builder> rollbackMetadata) {
            return this.rollbackMetadata((PipelineRollbackMetadata)((PipelineRollbackMetadata.Builder)PipelineRollbackMetadata.builder().applyMutation(rollbackMetadata)).build());
        }
    }
}

