/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.ActionType;
import software.amazon.awssdk.services.codepipeline.model.ActionTypeListCopier;
import software.amazon.awssdk.services.codepipeline.model.CodePipelineResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListActionTypesResponse
extends CodePipelineResponse
implements ToCopyableBuilder<Builder, ListActionTypesResponse> {
    private static final SdkField<List<ActionType>> ACTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionTypes").getter(ListActionTypesResponse.getter(ListActionTypesResponse::actionTypes)).setter(ListActionTypesResponse.setter(Builder::actionTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListActionTypesResponse.getter(ListActionTypesResponse::nextToken)).setter(ListActionTypesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListActionTypesResponse.memberNameToFieldInitializer();
    private final List<ActionType> actionTypes;
    private final String nextToken;

    private ListActionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.actionTypes = builder.actionTypes;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasActionTypes() {
        return this.actionTypes != null && !(this.actionTypes instanceof SdkAutoConstructList);
    }

    public final List<ActionType> actionTypes() {
        return this.actionTypes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionTypes() ? this.actionTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListActionTypesResponse)) {
            return false;
        }
        ListActionTypesResponse other = (ListActionTypesResponse)((Object)obj);
        return this.hasActionTypes() == other.hasActionTypes() && Objects.equals(this.actionTypes(), other.actionTypes()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListActionTypesResponse").add("ActionTypes", this.hasActionTypes() ? this.actionTypes() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionTypes": {
                return Optional.ofNullable(clazz.cast(this.actionTypes()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("actionTypes", ACTION_TYPES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListActionTypesResponse, T> g) {
        return obj -> g.apply((ListActionTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodePipelineResponse.BuilderImpl
    implements Builder {
        private List<ActionType> actionTypes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListActionTypesResponse model) {
            super(model);
            this.actionTypes(model.actionTypes);
            this.nextToken(model.nextToken);
        }

        public final List<ActionType.Builder> getActionTypes() {
            List<ActionType.Builder> result = ActionTypeListCopier.copyToBuilder(this.actionTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionTypes(Collection<ActionType.BuilderImpl> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copyFromBuilder(actionTypes);
        }

        @Override
        public final Builder actionTypes(Collection<ActionType> actionTypes) {
            this.actionTypes = ActionTypeListCopier.copy(actionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTypes(ActionType ... actionTypes) {
            this.actionTypes(Arrays.asList(actionTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionTypes(Consumer<ActionType.Builder> ... actionTypes) {
            this.actionTypes(Stream.of(actionTypes).map(c -> (ActionType)((ActionType.Builder)ActionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListActionTypesResponse build() {
            return new ListActionTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodePipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListActionTypesResponse> {
        public Builder actionTypes(Collection<ActionType> var1);

        public Builder actionTypes(ActionType ... var1);

        public Builder actionTypes(Consumer<ActionType.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

